package dev.amble.ait.core.tardis.control.impl;


import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.drinks.DrinkRegistry;
import dev.amble.ait.core.drinks.DrinkUtil;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public class RefreshmentControl extends Control {
    private int currentIndex = 0;

    public RefreshmentControl() {
        super(AITMod.id("refreshment_control"));
    }

    @Override
    public Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        currentIndex = (currentIndex + 1) % DrinkRegistry.getInstance().size();
        class_1799 selectedItem = DrinkUtil.setDrink(new class_1799(AITItems.MUG), DrinkRegistry.getInstance().toList().get(currentIndex));

        tardis.extra().setRefreshmentItem(selectedItem);
        player.method_7353(class_2561.method_43470("Refreshment set to: " + selectedItem.method_7964().getString() + "!"), true);

        return Result.SUCCESS;
    }

    @Override
    public boolean requiresPower() {
        return true;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.ALARM;
    }
}
