package dev.amble.ait.core.tardis.control.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.item.KeyItem;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.util.TardisUtil;

public class SecurityControl extends Control {

    public SecurityControl() {
        // ⨷ ?
        super(AITMod.id("protocol_19"));
    }

    @Override
    public Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);

        if (!hasMatchingKey(player, tardis))
            return Result.FAILURE;

        boolean security = tardis.stats().security().get();
        tardis.stats().security().set(!security);
        return security ? Result.SUCCESS : Result.SUCCESS_ALT;
    }

    public static void runSecurityProtocols(Tardis tardis) {
        boolean security = tardis.stats().security().get();
        boolean leaveBehind = tardis.travel().leaveBehind().get();

        if (!security)
            return;

        List<class_3222> forRemoval = new ArrayList<>();

        if (leaveBehind) {
            for (class_3222 player : tardis.asServer().world().method_18456()) {
                if (!hasMatchingKey(player, tardis)) {
                    forRemoval.add(player);
                }
            }

            for (class_3222 player : forRemoval) {
                TardisUtil.teleportOutside(tardis, player);
            }
        }
    }

    public static boolean hasMatchingKey(class_3222 player, Tardis tardis) {
        if (player.method_5687(2))
            return true;

        if (!tardis.loyalty().get(player).isOf(tardis.permissions().p19Loyalty().get()))
            return false;

        if (!KeyItem.isKeyInInventory(player))
            return false;

        Collection<class_1799> keys = KeyItem.getKeysInInventory(player);

        for (class_1799 stack : keys) {
            Tardis found = KeyItem.getTardisStatic(player.method_37908(), stack);

            if (stack.method_7909() == AITItems.SKELETON_KEY)
                return true;

            if (found == tardis)
                return true;
        }

        return false;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.PROTOCOL_19;
    }

    @Override
    public long getDelayLength(Tardis tardis) {
        return 50;
    }
}
