package dev.amble.ait.core.tardis.control.impl;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public class SiegeModeControl extends Control {
    public static final class_2960 ID = AITMod.id("protocol_1913");

    private static final class_2561 ENABLED = class_2561.method_43471("tardis.message.control.siege.enabled");
    private static final class_2561 DISABLED = class_2561.method_43471("tardis.message.control.siege.disabled");

    public SiegeModeControl() {
        super(ID);
    }

    @Override
    public Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);

        if (tardis.travel().isCrashing() || tardis.travel().getState() != TravelHandlerBase.State.LANDED)
            return Result.FAILURE;

        tardis.siege().setActive(!tardis.siege().isActive());
        tardis.alarm().disable();
        player.method_7353(tardis.siege().isActive() ? ENABLED : DISABLED, true);

        return tardis.siege().isActive() ? Result.SUCCESS : Result.SUCCESS_ALT;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.SIEGE;
    }

    @Override
    public boolean requiresPower() {
        return false;
    }

    @Override
    public long getDelayLength(Tardis tardis) {
        return 200;
    }

    @Override
    protected SubSystem.IdLike requiredSubSystem() {
        return SubSystem.Id.DESPERATION;
    }
}
