package dev.amble.ait.core.tardis.control.impl;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1807;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7045;
import net.minecraft.class_7058;
import net.minecraft.class_7924;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.drtheo.queue.api.ActionQueue;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.link.LinkableItem;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.advancement.TardisCriterions;
import dev.amble.ait.core.drinks.DrinkUtil;
import dev.amble.ait.core.item.HandlesItem;
import dev.amble.ait.core.item.HypercubeItem;
import dev.amble.ait.core.item.KeyItem;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.core.likes.ItemOpinion;
import dev.amble.ait.core.likes.ItemOpinionRegistry;
import dev.amble.ait.core.lock.LockedDimensionRegistry;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.control.impl.pos.IncrementManager;
import dev.amble.ait.core.tardis.handler.SiegeHandler;
import dev.amble.ait.core.tardis.handler.distress.DistressCall;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.tardis.handler.travel.TravelUtil;
import dev.amble.ait.core.tardis.util.AsyncLocatorUtil;
import dev.amble.ait.data.Loyalty;

public class TelepathicControl extends Control {

    public static final int RADIUS = 256;

    public TelepathicControl() {
        super(AITMod.id("telepathic_circuit"));
    }

    @Override
    public Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);

        if (tardis.stats().security().get() && !KeyItem.hasMatchingKeyInInventory(player, tardis))
            return Result.FAILURE;

        class_1799 held = player.method_6047();
        class_1792 type = held.method_7909();

        if (type == class_1802.field_8621) {
            tardis.siege().texture().set(SiegeHandler.BRICK_TEXTURE);
            return Result.FAILURE;
        }

        if (type == class_1802.field_20391) {
            tardis.siege().texture().set(SiegeHandler.DEFAULT_TEXTURRE);
            return Result.FAILURE;
        }

        if (type == class_1802.field_8537) {
            tardis.siege().texture().set(SiegeHandler.APERTURE_TEXTURE);
            return Result.FAILURE;
        }

        if (type == class_1802.field_20402) {
            tardis.siege().texture().set(SiegeHandler.COMPANION_TEXTURE);
            return Result.FAILURE;
        }

        if (type instanceof LinkableItem linker) {
            if (linker instanceof SonicItem || linker instanceof HandlesItem)
                return Result.FAILURE;

            linker.link(held, tardis);
            world.method_8396(null, player.method_24515(), class_3417.field_43154, class_3419.field_15245,
                    1.0F, 1.0F);
            return Result.SUCCESS_ALT;
        }

        if (type instanceof class_1807) {
            if (!held.method_7938())
                return Result.FAILURE;

            tardis.stats().setName(held.method_7964().getString());
            world.method_8396(null, player.method_24515(), class_3417.field_14785, class_3419.field_15245, 1F, 1.0F);

            if (!player.method_7337())
                held.method_7934(1);

            return Result.SUCCESS;
        }

        if (type instanceof HypercubeItem) {
            DistressCall call = HypercubeItem.getCall(held, world.method_8503().method_3780());

            if (call == null) {
                // create new call
                call = DistressCall.create(tardis, held.method_7938() ? held.method_7964().getString() : "SOS", true);
                HypercubeItem.setCall(held, call);
            }

            if (call.canSend(tardis.getUuid())) {
                call.send(tardis.getUuid(), held);
            }

            // receive and process call
            call.summon(tardis, held);
            return Result.SUCCESS;
        }

        if (held.method_31574(class_1802.field_8137) && tardis.loyalty().get(player).isOf(Loyalty.Type.PILOT)) {
            tardis.selfDestruct().boom();

            if (!(tardis.selfDestruct().isQueued()))
                return Result.FAILURE;

            if (!player.method_7337())
                held.method_7934(1);

            return Result.SUCCESS;
        }

        if (isLiquid(held))
            return spillLiquid(tardis, world, console, player);

        if (LockedDimensionRegistry.tryUnlockDimension(player, held, tardis.asServer()))
            return Result.SUCCESS;

        ItemOpinion opinion = ItemOpinionRegistry.getInstance().get(held.method_7909()).orElse(null);
        if (opinion != null && tardis.opinions().contains(opinion) && (player.field_7520 >= opinion.cost() || player.method_7337())) {
            opinion.apply(tardis.asServer(), player);

            player.method_51469().method_8396(null, console, AITSounds.TARDIS_BLING, class_3419.field_15256, 0.25f, 1f);
            player.method_51469().method_14199((opinion.likes()) ? class_2398.field_11201 : class_2398.field_11231, console.method_46558().method_10216(),
                    console.method_46558().method_10214() + 1, console.method_46558().method_10215(), 1, 0f, 1F, 0f, 5.0F);

            return Result.SUCCESS;
        }

        class_2561 text = class_2561.method_43471("tardis.message.control.telepathic.choosing");
        player.method_7353(text, true);

        CachedDirectedGlobalPos globalPos = tardis.travel().position();

        locateStructureOfInterest(player, tardis, globalPos.getWorld(), globalPos.getPos());
        return Result.SUCCESS;
    }

    public static boolean isLiquid(class_1799 held) {
        return (held.method_31574(AITItems.MUG) && DrinkUtil.getDrink(held) != DrinkUtil.EMPTY)
                || held.method_31574(class_1802.field_8187) || held.method_31574(class_1802.field_8705) || held.method_31574(class_1802.field_8103);
    }

    public static Result spillLiquid(Tardis tardis, class_3218 world, class_2338 console, @Nullable class_3222 player) {
        /*
            This is an example of how to use the travel queue.
            This code enqueues a crash to be performed after dematerialization.
             */

        TravelHandler travel = tardis.travel();
        TravelHandlerBase.State state = travel.getState();

        ActionQueue drinkAction = new ActionQueue();

        drinkAction.thenRun(() -> {
            // This is called after the dematerialization is complete
            travel.speed(travel.maxSpeed().get());
            travel.crash();
            tardis.crash().addRepairTicks(1500);

            world.method_14199(class_2398.field_27783, console.method_46558().method_10216() + 0.5f, console.method_46558().method_10214() + 1.25, console.method_46558().method_10215() + 0.5f,
                    5 * 10, 0, 0, 0, 0.1f * 10);

            world.method_14199(class_2398.field_11236, console.method_46558().method_10216() + 0.5f, console.method_46558().method_10214() + 1.25, console.method_46558().method_10215() + 0.5f,
                    5 * 10, 0, 0, 0, 0.1f * 10);


            world.method_8396(null, console, class_3417.field_15152, class_3419.field_15245, 1.0f, 1.0f);
            world.method_8396(null, console, AITSounds.SIEGE_ENABLE, class_3419.field_15245, 1.0f, 1.0f);

            if (player != null) {
                TardisCriterions.BRAND_NEW.trigger(player);
            }
        });

        if (state == TravelHandlerBase.State.LANDED) {
            boolean hadAutopilot = travel.autopilot();

            travel.autopilot(true);

            TravelUtil.randomPos(tardis, 100000, 100000, cached -> {
                tardis.travel().destination(cached);
                tardis.removeFuel(0.1d * IncrementManager.increment(tardis) * tardis.travel().instability());
            });

            travel.dematerialize().ifPresent(tr -> {
                // These only run if the dematerialization is successful

                tr.thenRun(drinkAction);

                // This is called just before the dematerialization starts
                tardis.alarm().enable();

                world.method_14199(class_2398.field_27783, console.method_46558().method_10216() + 0.5f, console.method_46558().method_10214() + 1.25, console.method_46558().method_10215() + 0.5f,
                        5 * 10, 0, 0, 0, 0.1f * 10);

                world.method_14199(class_2398.field_11236, console.method_46558().method_10216() + 0.5f, console.method_46558().method_10214() + 1.25, console.method_46558().method_10215() + 0.5f,
                        5 * 10, 0, 0, 0, 0.1f * 10);

                world.method_8396(null, console, class_3417.field_15152, class_3419.field_15245, 1.0f, 1.0f);
                world.method_8396(null, console, AITSounds.SIEGE_ENABLE, class_3419.field_15245, 1.0f, 1.0f);
            });

            travel.autopilot(hadAutopilot);

            return Result.SUCCESS;
        }

        if (state == TravelHandlerBase.State.FLIGHT) {
            drinkAction.execute();

            return Result.SUCCESS;
        }

        return Result.FAILURE;
    }

    public static void locateStructureOfInterest(class_3222 player, Tardis tardis, class_3218 world,
                                                 class_2338 source) {
        if (world.method_27983() == class_1937.field_25180) {
            getStructureViaChunkGen(player, tardis, world, source, RADIUS, class_7058.field_37182);
        } else if (world.method_27983() == class_1937.field_25181) {
            getStructureViaChunkGen(player, tardis, world, source, RADIUS, class_7058.field_37184);
        } else if (world.method_27983() == class_1937.field_25179) {
            getStructureViaWorld(player, tardis, world, source, RADIUS, class_7045.field_37045);
        } else {
            class_2378<class_3195> registry = world.method_30349().method_30530(class_7924.field_41246);
            // get a list of all the registry entries
            List<class_6880<class_3195>> structures = new ArrayList<>();

            for (int i = 0; i < registry.method_10204() - 1; i++) {
                structures.add(registry.method_40265(i).orElseThrow());
            }

            locateWithChunkGenAsync(player, tardis, class_6885.method_40242(structures), world, source, RADIUS);
        }
    }

    public static void getStructureViaChunkGen(class_3222 player, Tardis tardis, class_3218 world,
                                               class_2338 pos, int radius, class_5321<class_3195> key) {
        class_2378<class_3195> registry = world.method_30349().method_30530(class_7924.field_41246);

        if (registry.method_40264(key).isPresent())
            locateWithChunkGenAsync(player, tardis, class_6885.method_40246(registry.method_40264(key).get()), world, pos,
                    radius);
    }

    public static void getStructureViaWorld(class_3222 player, Tardis tardis, class_3218 world, class_2338 pos,
                                            int radius, class_6862<class_3195> key) {
        locateWithWorldAsync(player, tardis, key, world, pos, radius);
    }

    @Override
    public boolean requiresPower() {
        return false;
    }

    @Override
    public long getDelayLength(Tardis tardis) {
        return 120;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.TELEPATHIC_CIRCUITS;
    }

    public static void locateWithChunkGenAsync(class_3222 player, Tardis tardis,
                                               class_6885<class_3195> structureList, class_3218 world, class_2338 center, int radius) {
        AsyncLocatorUtil.locate(world, structureList, center, radius, false).thenOnServerThread(pos -> {
            class_2338 newPos = pos != null ? pos.getFirst() : null;
            if (newPos != null) {
                tardis.travel().forceDestination(cached -> cached.pos(newPos.method_33096(75)));
                tardis.removeFuel(500 * tardis.travel().instability());
                player.method_7353(class_2561.method_43471("tardis.message.control.telepathic.success"), true);
            } else {
                player.method_7353(class_2561.method_43471("tardis.message.control.telepathic.failed"), true);
            }
        });
    }

    public static void locateWithWorldAsync(class_3222 player, Tardis tardis, class_6862<class_3195> structureTagKey,
                                            class_3218 world, class_2338 center, int radius) {
        AsyncLocatorUtil.locate(world, structureTagKey, center, radius, false).thenOnServerThread(pos -> {
            if (pos != null) {
                tardis.travel().forceDestination(cached -> cached.pos(pos.method_33096(75)));
                tardis.removeFuel(500 * tardis.travel().instability());
                player.method_7353(class_2561.method_43471("tardis.message.control.telepathic.success"), true);
            } else {
                player.method_7353(class_2561.method_43471("tardis.message.control.telepathic.failed"), true);
            }
        });
    }

}
