package dev.amble.ait.core.tardis.control.impl;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public class ThrottleControl extends Control {

    public ThrottleControl() {
        super(AITMod.id("throttle"));
    }

    @Override
    public Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);

        if (tardis.isInDanger())
            return Result.FAILURE;

        TravelHandler travel = tardis.travel();
        TravelHandlerBase.State state = travel.getState();

        if (TelepathicControl.isLiquid(player.method_6047())) {
            return TelepathicControl.spillLiquid(tardis, world, console, player);
        }

        if (!leftClick) {
            if (player.method_5715()) {
                travel.speed(travel.maxSpeed().get());
            } else {
                if (!tardis.subsystems().stabilisers().isEnabled() && travel.speed() >= 3) {
                    player.method_7353(class_2561.method_43471("ait.tardis.control.throttle.stabilisers_disabled"), true);
                } else {
                    travel.increaseSpeed();
                }
            }
        } else {
            if (player.method_5715()) {
                travel.speed(0);
            } else {
                travel.decreaseSpeed();
            }
        }

        if (travel.getState() == TravelHandler.State.DEMAT)
            tardis.sequence().setActivePlayer(player);


        return player.method_5715() ? Result.SUCCESS_ALT : Result.SUCCESS;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.THROTTLE_PULL;
    }

    @Override
    public boolean requiresPower() {
        return false;
    }
}
