package dev.amble.ait.core.tardis.control.impl.pos;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public class IncrementControl extends Control {

    public IncrementControl() {
        super(AITMod.id("increment"));
    }

    @Override
    public Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);

        if (!leftClick) {
            IncrementManager.nextIncrement(tardis);
        } else {
            IncrementManager.prevIncrement(tardis);
        }

        messagePlayerIncrement(player, tardis);

        return leftClick ? Result.SUCCESS_ALT : Result.SUCCESS;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.CRANK;
    }

    private void messagePlayerIncrement(class_3222 player, Tardis tardis) {
        class_2561 text = class_2561.method_43471("tardis.message.control.increment.info")
                .method_10852(class_2561.method_43470("" + IncrementManager.increment(tardis)));
        player.method_7353(text, true);
    }

    @Override
    public boolean shouldHaveDelay() {
        return false;
    }
}
