package dev.amble.ait.core.tardis.control.impl.pos;

import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;

public abstract class PosControl extends Control {

    private final PosType type;

    public PosControl(PosType type) {
        super(AITMod.id(type.method_15434()));
        this.type = type;
    }

    @Override
    public Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console,
            boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);

        TravelHandler travel = tardis.travel();
        CachedDirectedGlobalPos destination = travel.destination();

        class_2338 pos = this.type.add(destination.getPos(),
                (leftClick) ? -IncrementManager.increment(tardis) : IncrementManager.increment(tardis),
                destination.getWorld());

        travel.destination(destination.pos(pos));
        messagePlayerDestination(player, travel);
        return Result.SUCCESS;
    }

    private void messagePlayerDestination(class_3222 player, TravelHandler travel) {
        CachedDirectedGlobalPos globalPos = travel.destination();
        class_2338 pos = globalPos.getPos();

        class_2561 text = class_2561.method_43471("tardis.message.control.randomiser.poscontrol")
                .method_10852(class_2561.method_43470(" " + pos.method_10263() + " | " + pos.method_10264() + " | " + pos.method_10260()));
        player.method_7353(text, true);
    }

    @Override
    public boolean shouldHaveDelay() {
        return false;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.XYZ;
    }
}
