package dev.amble.ait.core.tardis.control.sequences;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;

// should this be an interface? - No :)
public class Sequence {
    public class_2960 id() {
        return AITMod.id("sequence");
    }

    /**
     * A list of controls needed to execute the sequence, in the order they should
     * be executed
     */
    public List<Control> getControls() {
        return new ArrayList<>();
    }

    public Long timeToFail() {
        return 0L;
    }

    /**
     * @param recent
     *            Compares the recent controls to this sequence, if everything
     *            matches then it is finished
     */
    public boolean isFinished(RecentControls recent) {
        return recent.equals(this.getControls());
    }

    public void execute(Tardis tardis, @Nullable class_3222 player) {
        if (player != null) {
            tardis.loyalty().get(player).add(1);
        }
    }

    public void executeMissed(Tardis tardis, @Nullable class_3222 player) {
        if (player != null) {
            tardis.loyalty().get(player).subtract(2);
        }
    }

    public class_2561 sequenceStartMessage() {
        return class_2561.method_30163("");
    }

    public boolean wasMissed(RecentControls recent, int ticks) {
        if (recent.size() >= this.getControls().size() && recent != this.getControls()) {
            recent.clear();
        }
        return ticks >= this.timeToFail() /* || (recent.size() > this.getControls().size()) */;
    }

    public boolean controlPartOfSequence(Control control) {
        return this.getControls().contains(control);
    }

    public void sendMessageToInteriorPlayers(List<class_3222> playersInInterior) {
        if (playersInInterior.isEmpty())
            return;
        for (class_3222 player : playersInInterior) {
            player.method_7353(this.sequenceStartMessage(), true);
        }
    }

    public interface ExecuteSequence {
        void run(Tardis tardis);
    }

    public static class Builder extends Sequence {

        private final class_2960 id;
        private final List<Control> controls;
        private final ExecuteSequence execute;
        private final ExecuteSequence executeMissed;
        private final Long timeToFail;
        private final class_2561 sequenceStartMessage;

        private Builder(class_2960 id, ExecuteSequence execute, ExecuteSequence executeMissed, Long timeToFail,
                class_2561 sequenceStartMessage, Control... controls) {
            this.id = id;
            this.controls = List.of(controls);
            this.execute = execute;
            this.executeMissed = executeMissed;
            this.timeToFail = timeToFail;
            this.sequenceStartMessage = sequenceStartMessage;
        }

        public static Sequence create(class_2960 id, ExecuteSequence execute, ExecuteSequence executeMissed,
                Long timeToFail, class_2561 sequenceStartMessage, Control... controls) {
            return new Builder(id, execute, executeMissed, timeToFail, sequenceStartMessage, controls);
        }

        @Override
        public class_2960 id() {
            return this.id;
        }

        @Override
        public List<Control> getControls() {
            return this.controls;
        }

        @Override
        public void execute(Tardis tardis, @Nullable class_3222 player) {
            this.execute.run(tardis);
        }

        @Override
        public void executeMissed(Tardis tardis, @Nullable class_3222 player) {
            this.executeMissed.run(tardis);
        }

        @Override
        public Long timeToFail() {
            return this.timeToFail;
        }

        @Override
        public class_2561 sequenceStartMessage() {
            return this.sequenceStartMessage;
        }
    }
}
