package dev.amble.ait.core.tardis.control.sequences;

import java.util.UUID;

import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.tardis.TardisDesktop;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.registry.impl.SequenceRegistry;

public class SequenceHandler extends TardisComponent implements TardisTickable {
    @Exclude
    private RecentControls recent;

    private int ticks = 0;

    @Exclude
    private Sequence activeSequence;

    private static final class_5819 random = class_5819.method_43047();
    private UUID playerUUID;

    public SequenceHandler() {
        super(Id.SEQUENCE);
    }

    @Override
    protected void onInit(InitContext ctx) {
        recent = new RecentControls(tardis.getUuid());
        activeSequence = null;
    }

    public void setActivePlayer(class_3222 player) {
        this.playerUUID = player.method_5667();
    }

    public class_3222 getActivePlayer() {
        if (this.playerUUID == null)
            return null;

        class_3218 world = this.tardis.asServer().world();

        if (world == null)
            return null;

        return (class_3222) world.method_18470(this.playerUUID);
    }

    public void add(Control control, class_3222 player, class_2338 console) {
        if (this.getActiveSequence() == null || recent == null)
            return;

        recent.add(control);
        ticks = 0;

        this.setActivePlayer(player);
        this.doesControlIndexMatch(control);
        this.compareToSequences(console);
    }

    public boolean doesControlIndexMatch(Control control) {
        if (recent == null || this.getActiveSequence() == null)
            return false;

        if (recent.indexOf(control) != this.getActiveSequence().getControls().indexOf(control)) {
            recent.remove(control);
            return false;
        }

        return true;
    }

    public boolean hasActiveSequence() {
        return this.activeSequence != null;
    }

    public void setActiveSequence(@Nullable Sequence sequence, boolean setTicksTo0) {
        if (setTicksTo0)
            this.ticks = 0;

        this.activeSequence = sequence;

        if (this.activeSequence == null)
            return;

        this.activeSequence.sendMessageToInteriorPlayers(tardis.asServer().world().method_18456());
    }

    public void triggerRandomSequence(boolean setTicksTo0) {
        if (setTicksTo0)
            ticks = 0;

        int rand = random.method_39332(0, SequenceRegistry.REGISTRY.method_10204());
        Sequence sequence = SequenceRegistry.REGISTRY.method_10200(rand);

        if (sequence == null)
            return;

        this.activeSequence = sequence;
        this.activeSequence.sendMessageToInteriorPlayers(tardis.asServer().world().method_18456());

        this.tardis().getDesktop().playSoundAtEveryConsole(class_3417.field_14891);
    }

    @Nullable public Sequence getActiveSequence() {
        return activeSequence;
    }

    private void compareToSequences(class_2338 console) {
        if (this.getActiveSequence() == null)
            return;

        if (this.recent == null)
            this.recent = new RecentControls(this.tardis().getUuid());

        if (this.getActiveSequence().isFinished(this.recent)) {
            recent.clear();
            this.getActiveSequence().execute(this.tardis(), this.getActivePlayer());

            this.doCompletedControlEffects(console);
            this.setActiveSequence(null, true);
        } else if (this.getActiveSequence().wasMissed(this.recent, ticks)) {
            recent.clear();
            this.getActiveSequence().executeMissed(this.tardis(), this.getActivePlayer());

            this.doMissedControlEffects(console);
            this.setActiveSequence(null, true);
        } else if (recent.size() >= this.getActiveSequence().getControls().size()) {
            recent.clear();
        }
    }

    private void doMissedControlEffects(@Nullable class_2338 console) {
        class_3218 world = this.tardis.asServer().world();

        if (console == null) {
            this.tardis.getDesktop().getConsolePos().forEach(pos -> SequenceHandler.missedControlEffects(world, pos));
            return;
        }

        SequenceHandler.missedControlEffects(world, console);
    }

    public static void missedControlEffects(class_3218 world, class_2338 pos) {
        TardisDesktop.playSoundAtConsole(world, pos, class_3417.field_15152, class_3419.field_15245, 3f, 1f);
        class_243 vec3d = class_243.method_24955(pos).method_1031(0.0, 1.2f, 0.0);

        world.method_14199(class_2398.field_27783, vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), 20, 0.4F, 1F, 0.4F,
                5.0F);
        world.method_14199(class_2398.field_11231, vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), 1, 0.4F, 1F, 0.4F,
                0.5F);
        world.method_14199(class_2398.field_11239, vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), 7, 0.4F, 1F, 0.4F,
                0.5F);
        world.method_14199(class_2398.field_17909, vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), 4, 0.4F, 1F, 0.4F, 5.0F);
        world.method_14199(new class_2390(new Vector3f(0.2f, 0.2f, 0.2f), 4f), vec3d.method_10216(), vec3d.method_10214(),
                vec3d.method_10215(), 20, 0.0F, 1F, 0.0F, 2.0F);
    }

    private void doCompletedControlEffects(@Nullable class_2338 console) {
        class_3218 world = this.tardis.asServer().world();

        if (console == null) {
            this.tardis.getDesktop().getConsolePos().forEach(pos -> SequenceHandler.completedControlEffects(world, pos));
            return;
        }

        SequenceHandler.completedControlEffects(world, console);
    }

    public static void completedControlEffects(class_3218 world, class_2338 pos) {
        TardisDesktop.playSoundAtConsole(world, pos, class_3417.field_14627, class_3419.field_15245, 3f, 1f);
        class_243 vec3d = class_243.method_24955(pos).method_1031(0.0, 1.2f, 0.0);

        spawnControlParticles(world, vec3d);
        world.method_14199(class_2398.field_11201, vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), 1, 0.4F, 1F, 0.4F, 0.5F);
    }

    public static void spawnControlParticles(class_3218 world, class_243 vec3d) {
        world.method_14199(class_2398.field_28479, vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), 12, 0.4F, 1F, 0.4F, 5.0F);
        world.method_14199(class_2398.field_29644, vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), 12, 0.4F, 1F, 0.4F,
                5.0F);
    }

    @Override
    public void tick(MinecraftServer server) {
        if (this.getActiveSequence() == null)
            return;

        this.ticks++;
        if (this.ticks >= this.getActiveSequence().timeToFail()) {
            this.compareToSequences(null);

            this.recent.clear();
            this.ticks = 0;
        }
    }

    public boolean controlPartOfSequence(Control control) {
        if (this.getActiveSequence() == null)
            return false;

        return this.getActiveSequence().controlPartOfSequence(control);
    }
}
