package dev.amble.ait.core.tardis.handler;

import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.apache.commons.lang3.StringUtils;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.data.datapack.exterior.BiomeOverrides;
import dev.amble.ait.data.enummap.Ordered;
import dev.amble.ait.data.properties.Property;
import dev.amble.ait.data.properties.Value;

/**
 * @author Loqor
 * TODO reminder to work on this more, making it so you have to
 *         brush off different biomes if you don't just demat/remat + having to
 *         land on the respective blocks / has to snow for it to take effect.
 */
public class BiomeHandler extends KeyedTardisComponent {

    private static final Property<BiomeType> TYPE = Property.forEnum("type", BiomeType.class, BiomeType.DEFAULT);
    private final Value<BiomeType> type = TYPE.create(this);

    static {
        TardisEvents.DEMAT.register(tardis -> {
            tardis.<BiomeHandler>handler(Id.BIOME).forceTypeDefault();
            return TardisEvents.Interaction.PASS;
        });
        TardisEvents.LANDED.register(tardis -> tardis.<BiomeHandler>handler(Id.BIOME).update());
        TardisEvents.ENTER_FLIGHT.register(tardis -> tardis.<BiomeHandler>handler(Id.BIOME).forceTypeDefault());
    }

    public BiomeHandler() {
        super(Id.BIOME);
    }

    @Override
    public void onLoaded() {
        type.of(this, TYPE);
    }

    public void update() {
        this.update(this.tardis.travel().position());
    }

    public void update(CachedDirectedGlobalPos globalPos) {
        if (globalPos == null)
            return;

        class_6880<class_1959> entry = globalPos.getWorld().method_23753(globalPos.getPos());
        BiomeType biome = getTagForBiome(entry);

        this.type.set(biome);
        this.sync();
    }

    public void forceTypeDefault() {
        this.type.set(BiomeType.DEFAULT);
        this.sync();
    }

    public BiomeType getBiomeKey() {
        return this.type.get();
    }

    // FIXME(PERFORMANCE)
    private static BiomeType getTagForBiome(class_6880<class_1959> biome) {
        if (biome.method_40220(ConventionalBiomeTags.SNOWY) || biome.method_40220(ConventionalBiomeTags.SNOWY_PLAINS)
                || biome.method_40220(ConventionalBiomeTags.ICY))
            return BiomeType.SNOWY;

        if (biome.method_40220(ConventionalBiomeTags.DESERT) || biome.method_40220(ConventionalBiomeTags.BEACH)
                || biome.method_40220(ConventionalBiomeTags.DEAD))
            return BiomeType.SANDY;

        if (biome.method_40220(ConventionalBiomeTags.BADLANDS))
            return BiomeType.RED_SANDY;

        if (biome.method_40220(ConventionalBiomeTags.SWAMP))
            return BiomeType.MUDDY;

        if (biome.method_40220(ConventionalBiomeTags.IN_THE_END))
            return BiomeType.CHORUS;

        if (biome.method_40220(ConventionalBiomeTags.FLORAL))
            return BiomeType.CHERRY;

        class_5321<class_1959> biomeKey = biome.method_40230().orElse(null);

        if (biomeKey == class_1972.field_37543)
            return BiomeType.SCULK;

        if (biomeKey == class_1972.field_42720)
            return BiomeType.CHERRY;

        return BiomeType.DEFAULT;
    }

    public enum BiomeType implements class_3542, Ordered {
        DEFAULT, SNOWY("_snowy"),
        SCULK("_sculk"),
        SANDY("_sand"),
        RED_SANDY("_red_sand"),
        MUDDY("_mud"),
        CHORUS("_chorus"),
        CHERRY("_cherry");

        public static final BiomeType[] VALUES = BiomeType.values();
        public static final class_7292<BiomeType> CODEC = class_3542.method_28140(() -> VALUES);

        private final String suffix;

        BiomeType(String suffix) {
            this.suffix = suffix;
        }

        BiomeType() {
            this(null);
        }

        @Override
        public String method_15434() {
            return StringUtils.capitalize(this.toString().replace("_", " "));
        }

        public class_2960 getTexture(class_2960 texture) {
            if (this.suffix == null)
                return texture;

            String path = texture.method_12832();
            return AITMod.id(path.substring(0, path.length() - 4) + this.suffix + ".png");
        };

        public class_2960 get(BiomeOverrides overrides) {
            if (overrides == null)
                return null;

            return overrides.get(this);
        }

        @Override
        public int index() {
            return ordinal();
        }
    }
}
