package dev.amble.ait.core.tardis.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.drtheo.gaslighter.Gaslighter3000;
import dev.drtheo.gaslighter.api.FakeBlockEvents;
import dev.drtheo.gaslighter.impl.FakeStructureWorldAccess;
import org.jetbrains.annotations.NotNull;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2622;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2944;
import net.minecraft.class_2960;
import net.minecraft.class_2964;
import net.minecraft.class_2975;
import net.minecraft.class_3005;
import net.minecraft.class_3031;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4625;
import net.minecraft.class_4781;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.world.gen.feature.*;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.util.NetworkUtil;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.schema.exterior.variant.adaptive.AdaptiveVariant;

public class ChameleonHandler extends KeyedTardisComponent {

    @Exclude
    private Gaslighter3000 gaslighter;

    static {
        TardisEvents.ENTER_FLIGHT.register(tardis -> {
            tardis.chameleon().clearDisguise();
        });

        TardisEvents.START_FALLING.register(tardis -> {
            tardis.chameleon().clearDisguise();
        });

        TardisEvents.TOGGLE_SIEGE.register((tardis, active) -> {
            if (shouldNotBeDisguised(tardis)) {
                tardis.chameleon().clearDisguise();
            } else {
                tardis.chameleon().applyDisguise();
            }
        });

        TardisEvents.LANDED.register(tardis -> {
            if (!shouldNotBeDisguised(tardis))
                tardis.chameleon().applyDisguise();
        });

        TardisEvents.SEND_TARDIS.register((tardis, player) -> {
            if (player.method_14208())
                return;

            if (shouldNotBeDisguised(tardis))
                return;

            CachedDirectedGlobalPos pos = tardis.travel().position();

            if (pos == null || pos.getWorld() != player.method_51469())
                return;

            tardis.chameleon().applyDisguise(player);
        });

        TardisEvents.EXTERIOR_CHANGE.register(tardis -> {
            if (shouldNotBeDisguised(tardis)) {
                tardis.chameleon().clearDisguise();
            } else {
                tardis.chameleon().applyDisguise();
            }
        });

        TardisEvents.DOOR_USED.register((tardis,  player) -> {
            if (player == null || !isDisguised(tardis))
                return DoorHandler.InteractionResult.CONTINUE;

            if (!shouldNotBeDisguised(tardis)) {
                tardis.chameleon().applyDisguise(player);
                return DoorHandler.InteractionResult.CONTINUE;
            }

            CachedDirectedGlobalPos cached = tardis.travel().position();
            Optional<ExteriorBlockEntity> blockEntity = tardis.getExterior().findExteriorBlock();

            if (blockEntity.isEmpty())
                return DoorHandler.InteractionResult.CONTINUE;

            player.field_13987.method_14364(new class_2626(cached.getWorld(), cached.getPos()));
            player.field_13987.method_14364(new class_2626(cached.getWorld(), cached.getPos().method_10084()));
            player.field_13987.method_14364(class_2622.method_38585(blockEntity.get()));

            return DoorHandler.InteractionResult.CONTINUE;
        });

        FakeBlockEvents.INTERACT.register((player, hand, pos) -> {
            // allow only main hand clicks!
            if (hand != class_1268.field_5808)
                return FakeBlockEvents.Action.REMOVE;

            return FakeBlockEvents.Action.CONTINUE;
        });

        FakeBlockEvents.CHECK.register((player, hand, state, pos) -> {
            if (state.method_27852(AITBlocks.EXTERIOR_BLOCK))
                return FakeBlockEvents.Action.CONTINUE;

            class_3218 world = player.method_51469();

            // should be cheap enough
            if (hand == class_1268.field_5808 && world.method_8321(pos.method_10074()) instanceof ExteriorBlockEntity ebe) {
                ebe.useOn(world, player.method_5715(), player);
                return FakeBlockEvents.Action.CONTINUE;
            }

            shitParticles(world, pos);
            return FakeBlockEvents.Action.REMOVE;
        });

        FakeBlockEvents.PLACED.register((world, state, pos) -> shitParticles(world, pos));
        FakeBlockEvents.REMOVED.register(ChameleonHandler::shitParticles);
    }

    private class_2960 lastFeature = null;

    public ChameleonHandler() {
        super(Id.CHAMELEON);
    }

    @Override
    public void postInit(InitContext ctx) {
        if (ctx.created() || !this.isServer()) return;

        if (lastFeature == null)
            return;

        CachedDirectedGlobalPos cached = tardis.travel().position();

        class_2338 pos = cached.getPos();
        class_3218 world = cached.getWorld();

        Optional<class_6880.class_6883<class_2975<?, ?>>> feature =
                getRegistry(world).method_40264(asFeature(lastFeature));

        if (feature.isEmpty())
            return;

        this.gaslighter = new Gaslighter3000(world);
        if (!this.generate(world, pos, feature.get()) && !this.applyFallback(world, pos))
            return;

        if (!this.tryFixDisguise(world, pos))
            return;

        this.applyDisguise();
    }

    private static boolean shouldNotBeDisguised(Tardis tardis) {
        return !isDisguised(tardis) || !tardis.travel().isLanded()
                || tardis.siege().isActive() || tardis.door().isOpen()
                || tardis.flight().falling().get()
                || (tardis.travel().antigravs().get() && tardis.flight().shouldFall().get());
    }

    public static boolean isDisguised(Tardis tardis) {
        return tardis.getExterior().getVariant() instanceof AdaptiveVariant;
    }

    public void clearDisguise() {
        if (this.gaslighter == null)
            return;

        gaslighter.touchGrass();
        gaslighter.tweet();

        this.gaslighter = null;
        this.lastFeature = null;
    }

    /**
     * @return Whether the recalculation was successful
     */
    public boolean recalcDisguise() {
        if (this.gaslighter != null)
            return true;

        long start = System.currentTimeMillis();
        CachedDirectedGlobalPos cached = tardis.travel().position();
        class_3218 world = cached.getWorld();
        class_2338 pos = cached.getPos();

        this.gaslighter = new Gaslighter3000(world);
        boolean success = this.testBiome(world, pos);

        if (!success && !applyFallback(world, pos))
            return false;

        boolean result = this.tryFixDisguise(world, pos);
        AITMod.LOGGER.debug("Recalculated exterior in {}ms", System.currentTimeMillis() - start);

        return result;
    }

    private boolean tryFixDisguise(class_3218 world, class_2338 pos) {
        // check if the exterior's position is still an exterior
        if (!this.gaslighter.getAgenda(pos).method_27852(AITBlocks.EXTERIOR_BLOCK))
            return true;

        // if it is, then try applying fallback
        if (!this.applyFallback(world, pos)) {
            this.gaslighter = null;
            return false;
        }

        return true;
    }

    private boolean applyFallback(class_3218 world, class_2338 pos) {
        class_2680 below = world.method_8320(pos.method_10074());

        if (!isSafe(below)) {
            below = world.method_8320(pos.method_10087(2));

            if (!isSafe(below)) {
                this.notifyFailure();
                return false;
            }
        }

        this.gaslighter.spreadLies(pos, below);
        return true;
    }

    private void notifyFailure() {
        class_2561 text = class_2561.method_43471("tardis.message.chameleon.failed")
                .method_27692(class_124.field_1061);

        NetworkUtil.getSubscribedPlayers(tardis.asServer()).forEach(player ->
                player.method_7353(text, true));
    }

    private void applyDisguise(class_3222 player) {
        if (!this.recalcDisguise())
            return;

        this.gaslighter.tweet(player);
    }

    public void applyDisguise() {
        if (!this.recalcDisguise())
            return;

        this.gaslighter.tweet();
    }

    private boolean testBiome(class_3218 world, class_2338 pos) {
        class_6880<class_1959> biome = world.method_23753(pos);
        List<class_6880<class_2975<?, ?>>> trees = this.findTrees(world, biome);

        if (trees.isEmpty())
            return false;

        class_6880<class_2975<?, ?>> tree = trees.get(world.field_9229.method_43048(trees.size()));

        if (tree == null)
            return false;

        return this.generate(world, pos, tree);
    }

    private boolean generate(class_3218 world, class_2338 pos, class_6880<class_2975<?, ?>> feature) {
        feature.method_40230().ifPresent(k -> this.lastFeature = k.method_29177());

        FakeStructureWorldAccess access = new FakeStructureWorldAccess(world, gaslighter);
        return feature.comp_349().method_12862(access, world.method_14178().method_12129(), world.field_9229, pos);
    }

    private static boolean isSafe(class_2680 state) {
        return state.method_51367() && !state.method_45474();
    }

    private static final Set<Class<? extends class_3031<?>>> TREES = Set.of(
            class_2944.class, class_4625.class, class_4781.class,
            class_3005.class, class_2964.class
    );

    private static final class_5321<class_2975<?, ?>> CACTUS = asFeature(AITMod.id("cactus"));

    private List<class_6880<class_2975<?, ?>>> findTrees(class_3218 world, class_6880<class_1959> biome) {
        BiomeHandler biomeHandler = this.tardis.handler(Id.BIOME);
        List<class_6880<class_2975<?, ?>>> trees = new ArrayList<>();

        if (biomeHandler.getBiomeKey() == BiomeHandler.BiomeType.SANDY && world.field_9229.method_43048(5) != 0) {
            trees.add(getRegistry(world).method_40264(CACTUS).orElse(null));
            return trees;
        }

        for (class_6885<class_6796> feature : biome.comp_349().method_30970().method_30983()) {
            for (class_6880<class_6796> entry : feature) {
                class_6880<class_2975<?, ?>> configured = entry.comp_349().comp_334();

                if (isTree(configured.comp_349(), biome)) {
                    trees.add(configured);
                    break;
                } else {
                    boolean shouldBreak = false;

                    for (class_2975<?, ?> configuredFeature : configured.comp_349()
                            .comp_333().method_30649().toList()) {
                        if (!isTree(configuredFeature, biome))
                            continue;

                        trees.add(configured);
                        shouldBreak = true;
                        break;
                    }

                    if (shouldBreak)
                        break;
                }
            }
        }

        return trees;
    }

    public boolean isApplied() {
        return isDisguised(tardis) && gaslighter != null;
    }

    private static void shitParticles(class_3218 world, class_2338 pos) {
        class_243 center = pos.method_46558();
        world.method_14199(class_2398.field_11207, center.method_10216(), center.method_10214(), center.method_10215(),
                12, 0.3, 0.3, 0.3, 0);
    }

    private static boolean isTree(class_2975<?, ?> configured, class_6880<class_1959> biome) {
        class_3031<?> feature = configured.comp_332();

        for (Class<?> clazz : TREES) {
            if (clazz.isInstance(feature))
                return true;
        }

        return false;
    }

    @NotNull private static class_2378<class_2975<?, ?>> getRegistry(class_1937 world) {
        return world.method_30349().method_30530(class_7924.field_41239);
    }

    @NotNull private static class_5321<class_2975<?, ?>> asFeature(class_2960 id) {
        return class_5321.method_29179(class_7924.field_41239, id);
    }
}
