package dev.amble.ait.core.tardis.handler;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1541;
import net.minecraft.class_1548;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.server.MinecraftServer;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;

public class HadsHandler extends KeyedTardisComponent implements TardisTickable {

    private static final BoolProperty HADS_ENABLED = new BoolProperty("enabled", false);
    private static final BoolProperty IS_IN_ACTIVE_DANGER = new BoolProperty("is_in_active_danger", false);

    private final BoolValue enabled = HADS_ENABLED.create(this);
    private final BoolValue inDanger = IS_IN_ACTIVE_DANGER.create(this);

    public HadsHandler() {
        super(Id.HADS);
    }

    public boolean isActive() {
        return enabled.get();
    }

    public void setIsInDanger(boolean bool) {
        inDanger.set(bool);
    }

    public boolean isInDanger() {
        return inDanger.get();
    }

    @Override
    public void onLoaded() {
        enabled.of(this, HADS_ENABLED);
        inDanger.of(this, IS_IN_ACTIVE_DANGER);
    }

    @Override
    public void tick(MinecraftServer server) {
        if (isActive())
            tickingForDanger(tardis.travel().position().getWorld());
    }

    // @TODO Fix hads idk why its broken. duzo did something to the demat idk what
    // happened lol
    public void tickingForDanger(class_1937 world) {
        List<class_1297> listOfEntities = world.method_8333(null,
                new class_238(tardis.travel().position().getPos()).method_1014(3f), class_1301.field_6156);

        for (class_1297 entity : listOfEntities) {
            if (entity instanceof class_1548 creeperEntity) {
                if (creeperEntity.method_7007() > 0) {
                    setIsInDanger(true);
                    break;
                }
            } else if (entity instanceof class_1541) {
                setIsInDanger(true);
                break;
            }
            setIsInDanger(false);
        }

        dematerialiseWhenInDanger();
    }

    public void dematerialiseWhenInDanger() {
        TravelHandler travel = tardis.travel();
        TravelHandlerBase.State state = travel.getState();

        ServerAlarmHandler alarm = tardis.alarm();

        if (this.isInDanger()) {
            if (state == TravelHandlerBase.State.LANDED)
                travel.dematerialize();

            alarm.enable();
            return;
        }

        // FIXME this is dumb.
        if (state == TravelHandlerBase.State.FLIGHT)
            travel.rematerialize();

        if (state == TravelHandlerBase.State.MAT)
            alarm.disable();
    }

    public BoolValue enabled() {
        return enabled;
    }
}
