package dev.amble.ait.core.tardis.handler;

import java.util.ArrayList;
import java.util.List;

import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.data.DirectedBlockPos;
import dev.amble.lib.data.DirectedGlobalPos;
import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.common.TaskStage;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2595;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.AITDamageTypes;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.advancement.TardisCriterions;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.util.SafePosSearch;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.properties.Property;
import dev.amble.ait.data.properties.Value;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;
import dev.amble.ait.data.properties.integer.IntProperty;
import dev.amble.ait.data.properties.integer.IntValue;
import dev.amble.ait.data.schema.desktop.TardisDesktopSchema;
import dev.amble.ait.registry.impl.CategoryRegistry;
import dev.amble.ait.registry.impl.DesktopRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;

public class InteriorChangingHandler extends KeyedTardisComponent implements TardisTickable {
    public static final class_2960 CHANGE_DESKTOP = AITMod.id("change_desktop");
    private static final Property<class_2960> QUEUED_INTERIOR_PROPERTY = new Property<>(Property.IDENTIFIER, "queued_interior", new class_2960(""));
    private static final BoolProperty QUEUED = new BoolProperty("queued");
    private static final BoolProperty REGENERATING = new BoolProperty("regenerating");
    private static final int MIN_FUEL_COST = 5000;

    public static final int MAX_PLASMIC_MATERIAL_AMOUNT = 8;
    private static final class_2561 HINT_TEXT = class_2561.method_43471("tardis.message.growth.hint").method_27695(class_124.field_1063, class_124.field_1056);

    private final Value<class_2960> queuedInterior = QUEUED_INTERIOR_PROPERTY.create(this);
    private static final IntProperty PLASMIC_MATERIAL_AMOUNT = new IntProperty("plasmic_material_amount");
    private final IntValue plasmicMaterialAmount = PLASMIC_MATERIAL_AMOUNT.create(this);
    private static final BoolProperty HAS_CAGE = new BoolProperty("has_cage");
    private final BoolValue hasCage = HAS_CAGE.create(this);
    private final BoolValue queued = QUEUED.create(this);
    private final BoolValue regenerating = REGENERATING.create(this);

    @Exclude
    private boolean countdownStarted = false;

    @Exclude
    private List<class_1799> restorationChestContents;

    public InteriorChangingHandler() {
        super(Id.INTERIOR);
    }

    @Override
    public void onLoaded() {
        plasmicMaterialAmount.of(this, PLASMIC_MATERIAL_AMOUNT);
        hasCage.of(this, HAS_CAGE);
        queuedInterior.of(this, QUEUED_INTERIOR_PROPERTY);
        queued.of(this, QUEUED);
        regenerating.of(this, REGENERATING);

        if (this.isServer() && this.regenerating.get()) {
            this.regenerating.set(false);

            TardisDesktopSchema queued = this.getQueuedInterior();

            if (queued == null)
                return;

            tardis.interiorChangingHandler().queueInteriorChange(queued);
        }
    }

    static {
        TardisEvents.DEMAT.register(tardis -> {
            if (tardis.isGrowth()
                    || tardis.interiorChangingHandler().queued().get())
                return TardisEvents.Interaction.FAIL;

            return TardisEvents.Interaction.PASS;
        });

        TardisEvents.MAT.register(tardis -> {
            if (!tardis.isGrowth())
                return TardisEvents.Interaction.PASS;

            tardis.travel().autopilot(false);
            tardis.getExterior().setType(CategoryRegistry.CAPSULE);
            tardis.getExterior().setVariant(ExteriorVariantRegistry.CAPSULE_DEFAULT);
            return TardisEvents.Interaction.SUCCESS; // force mat even if checks fail
        });

        TardisEvents.LOSE_POWER.register(tardis -> tardis.interiorChangingHandler().queued.set(false));

        ServerPlayNetworking.registerGlobalReceiver(InteriorChangingHandler.CHANGE_DESKTOP,
                ServerTardisManager.receiveTardis(((tardis, server, player, handler, buf, responseSender) -> {
                    TardisDesktopSchema desktop = DesktopRegistry.getInstance().get(buf.method_10810());

                    if (tardis == null || desktop == null)
                        return;

                    // nuh uh no interior changing during flight
                    if (tardis.travel().getState() != TravelHandler.State.LANDED)
                        return;

                    TardisCriterions.REDECORATE.trigger(player);
                    tardis.interiorChangingHandler().queueInteriorChange(desktop);
                    tardis.alarm().enable();
                })));
    }

    public BoolValue queued() {
        return queued;
    }

    public int plasmicMaterialAmount() {
        return plasmicMaterialAmount.get();
    }

    public boolean hasCage() {
        return hasCage.get();
    }

    public void setHasCage(boolean value) {
        hasCage.set(value);
    }

    public void setPlasmicMaterialAmount(int amount) {
        plasmicMaterialAmount.set(amount);
    }

    public void addPlasmicMaterial(int amount) {
        plasmicMaterialAmount.set(Math.min(plasmicMaterialAmount() + amount, MAX_PLASMIC_MATERIAL_AMOUNT));
    }

    public BoolValue regenerating() {
        return regenerating;
    }

    public TardisDesktopSchema getQueuedInterior() {
        return DesktopRegistry.getInstance().get(queuedInterior.get());
    }

    public void queueInteriorChange(TardisDesktopSchema schema) {
        if (!this.canQueue())
            return;

        if (tardis.fuel().getCurrentFuel() < (MIN_FUEL_COST * tardis.travel().instability())) {
            tardis.asServer().world().method_18456().forEach(player -> {
                player.method_7353(
                        class_2561.method_43471("tardis.message.interiorchange.not_enough_fuel").method_27692(class_124.field_1061),
                        true);
            });

            return;
        }
        if (tardis.subsystems().isEnabled()) {
            tardis.asServer().world().method_18456().forEach(player -> {
                int count = 0;

                for (SubSystem subSystem : tardis.subsystems()) {
                    if (subSystem.isEnabled())
                        count++;
                }

                player.method_7353(
                        class_2561.method_43469("tardis.message.interiorchange.subsystems_enabled", count)
                                .method_27692(class_124.field_1061), false);
            });
        }

        AITMod.LOGGER.info("Queueing interior change for {} to {}", this.tardis, schema);

        this.queuedInterior.set(schema.id());
        this.queued.set(true);

        TravelHandler travel = this.tardis.travel();

        if (travel.getState() == TravelHandler.State.FLIGHT && !travel.isCrashing() && !tardis.isGrowth())
            travel.crash();

        restorationChestContents = new ArrayList<>();

        for (SubSystem system : tardis.subsystems()) {
            if (!system.isReal())
                continue;

            restorationChestContents.addAll(system.toStacks());
            AITMod.LOGGER.debug("Storing Subsystem, {} ({}) => {}", system.getId(), system.isEnabled(), system.toStacks());
        }
    }

    private void changeInterior() {
        tardis.getDesktop().changeInterior(this.getQueuedInterior(), true, true)
                .thenRun(() -> {
                    this.queued.set(false);
                    this.regenerating.set(false);

                    if (tardis.hasGrowthExterior()) {
                        TravelHandler travel = tardis.travel();

                        travel.autopilot(true);
                        travel.forceDemat();
                        this.replaceAllConsolesWithGrowth();
                    } else {
                        tardis.removeFuel(MIN_FUEL_COST * tardis.travel().instability());
                    }

                    TardisUtil.sendMessageToLinked(tardis.asServer(), class_2561.method_43469("tardis.message.interiorchange.success", tardis.stats().getName(), tardis.getDesktop().getSchema().name()));
                    this.tardis.getDesktop().getConsolePos().stream().findFirst().ifPresent(blockPos -> {
                        if (restorationChestContents == null || restorationChestContents.isEmpty()) {
                            AITMod.LOGGER.debug("No contents to save in recovery inventory in console for {}", this.tardis);
                            return;
                        }
                        if (this.tardis.asServer().world().method_8321(blockPos) instanceof ConsoleBlockEntity consoleBlockEntity) {
                            for (int i = 0; i < restorationChestContents.size() && i < consoleBlockEntity.getInventory().size(); i++) {
                                consoleBlockEntity.getInventory().set(i, restorationChestContents.get(i));
                            }
                        }
                    });//createChestAtInteriorDoor(restorationChestContents);

                    class_2394 particle = class_2398.field_11204;
                    tardis.door().setDoorParticles(particle);
                    Scheduler.get().runTaskLater(() -> {
                        tardis.door().setDoorParticles(null);
                    }, TaskStage.END_SERVER_TICK, TimeUnit.SECONDS, 3);
                }).execute();
    }

    /**
     * Replaces the console with air, and places soul sand beneath it.
     * @param cPos The position of the console to replace.
     */
    private void replaceConsoleWithGrowth(class_2338 cPos) {
        class_3218 world = tardis.asServer().world();

        if (!(world.method_8321(cPos) instanceof ConsoleBlockEntity console))
            return;

        world.method_8501(cPos, class_2246.field_10124.method_9564());
        world.method_8501(cPos.method_10074(), class_2246.field_10114.method_9564());

        console.onBroken();
    }

    /**
     * Replaces all consoles with growth.
     * @see #replaceConsoleWithGrowth(class_2338)
     */
    private void replaceAllConsolesWithGrowth() {
        for (class_2338 cPos : tardis.getDesktop().getConsolePos()) {
            replaceConsoleWithGrowth(cPos);
        }
    }

    private void createChestAtInteriorDoor(List<class_1799> contents) {
        if (contents == null || contents.isEmpty()) {
            AITMod.LOGGER.debug("No contents to save in recovery chest for {}", this.tardis);
            return;
        }

        DirectedBlockPos door = this.tardis.getDesktop().getDoorPos();

        CachedDirectedGlobalPos safe = CachedDirectedGlobalPos.create(
                this.tardis.asServer().world(),
                door.getPos().method_10079(door.toMinecraftDirection(), 2),
                door.getRotation()
        );

        // vars are ew, but fully qualifying the package name is worse.
        var ref = new dev.drtheo.queue.api.util.Value<class_2338>(null);

        SafePosSearch.wrapSafe(safe, SafePosSearch.Kind.MEDIAN, true,
                result -> this.finishCreatingChest(result, contents));
    }

    private void finishCreatingChest(CachedDirectedGlobalPos safe, List<class_1799> contents) {
        // set block to chest
        if (!(safe.getWorld().method_8320(safe.getPos()).method_26215())) {
            AITMod.LOGGER.error("Failed to create recovery chest at {} for {}", safe, this.tardis);
            return;
        }

        class_2350 doorDir = tardis.getDesktop().getDoorPos().toMinecraftDirection();
        safe.getWorld().method_8652(safe.getPos(), class_2246.field_10034.method_9564().method_11657(class_2281.field_10768, doorDir.method_10153()), class_2248.field_31036);

        // set chest contents
        class_2595 chest = (class_2595) safe.getWorld().method_8321(safe.getPos());
        List<class_1799> overflow = new ArrayList<>(contents);

        for (int i = 0; i < 27 && !overflow.isEmpty(); i++) {
            chest.method_5447(i, overflow.remove(0));
        }

        AITMod.LOGGER.debug("Created recovery chest at {} for {}", safe, this.tardis);

        if (!overflow.isEmpty())
            createChestAtInteriorDoor(overflow);
    }

    @Override
    public void tick(MinecraftServer server) {
        boolean isQueued = this.queued.get();

        if (server.method_3780() % 10 == 0 && this.tardis.isGrowth()) {
            this.generateInteriorWithItem();

            if (!isQueued) {
                if (server.method_3780() % 200 == 0 && this.hasEnoughPlasmicMaterial())
                    this.tardis.asServer().world().method_18456().forEach(player ->
                            player.method_7353(HINT_TEXT, true));

                if (this.tardis.door().isClosed()) {
                    this.tardis.door().openDoors();
                } else {
                    this.tardis.door().setLocked(false);
                }
            }
        }

        if (!isQueued)
            return;

        if (!this.canQueue()) {
            this.queued.set(false);
            this.regenerating.set(false);

            tardis.alarm().disable();
            return;
        }

        if (!TardisUtil.isInteriorEmpty(tardis.asServer())) {
            if (this.regenerating.get()) {
                class_1657 target = TardisUtil.getAnyPlayerInsideInterior(tardis.asServer().world());

                if (this.tardis().subsystems().lifeSupport().isEnabled()) {
                    TardisUtil.teleportOutside(tardis.asServer(), target);
                } else {
                    target.method_5643(AITDamageTypes.of(target.method_37908(), AITDamageTypes.INTERIOR_CHANGE), Float.MAX_VALUE);
                }
            }
        }

        if (!this.regenerating.get() && !this.countdownStarted) {
            this.startRegeneratingCountdown();
        }
    }

    private ServerAlarmHandler.Countdown startRegeneratingCountdown() {
        ServerAlarmHandler.Countdown cd = new ServerAlarmHandler.Countdown.Builder().bellTolls(5).message("tardis.message.interiorchange.regenerating").thenRun(() -> {
            tardis.getDesktop().startQueue(true);
            Scheduler.get().runTaskLater(this::changeInterior, TaskStage.END_SERVER_TICK, TimeUnit.SECONDS, 5);

            this.regenerating.set(true);
            this.countdownStarted = false;
        });

        this.tardis().alarm().enable(cd);
        this.countdownStarted = true;

        return cd;
    }

    public boolean hasEnoughPlasmicMaterial() {
        return this.plasmicMaterialAmount() == MAX_PLASMIC_MATERIAL_AMOUNT;
    }

    protected void generateInteriorWithItem() {
        if (!hasEnoughPlasmicMaterial()) {
            TardisUtil.sendMessageToInterior(tardis.asServer(), class_2561.method_43469("tardis.message.interiorchange.not_enough_plasmic_material", this.plasmicMaterialAmount()).method_27692(class_124.field_1080));
            return;
        }

        TardisUtil.getEntitiesInInterior(this.tardis, 50).stream()
                .filter(entity -> entity instanceof class_1542 item
                        && (item.method_6983().method_7909() == AITItems.PERSONALITY_MATRIX)
                        && entity.method_5799())
                .forEach(entity -> {
                    class_1542 item = (class_1542) entity;
                    class_1799 stack = item.method_6983();
                    DirectedGlobalPos position = this.tardis.travel().position();

                    if (position == null)
                        return;

                    this.tardis.setFuelCount(8000);

                    entity.method_37908().method_8396(null, entity.method_24515(), class_3417.field_14891,
                            class_3419.field_15245, 10.0F, 0.75F);
                    entity.method_37908().method_8396(null, position.getPos(), class_3417.field_14891,
                            class_3419.field_15245, 10.0F, 0.75F);

                    this.queueInteriorChange(DesktopRegistry.getInstance().get(AITMod.id("cave")));
                    if (stack.method_31574(AITItems.PERSONALITY_MATRIX)) {
                        class_2487 nbt = stack.method_7948();
                        if (nbt.method_10545("name")) {
                            this.tardis.stats().setName(nbt.method_10558("name"));
                        }
                    }

                    if (this.queued.get())
                        entity.method_31472();
                });
    }

    private boolean canQueue() {
        return tardis.isGrowth() || tardis.fuel().hasPower() || tardis.crash().isToxic();
    }
}
