package dev.amble.ait.core.tardis.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.Nameable;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.advancement.TardisCriterions;
import dev.amble.ait.core.likes.ItemOpinion;
import dev.amble.ait.core.likes.ItemOpinionRegistry;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.schema.console.ConsoleVariantSchema;
import dev.amble.ait.data.schema.desktop.TardisDesktopSchema;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.data.schema.sonic.SonicSchema;
import dev.amble.ait.registry.impl.DesktopRegistry;
import dev.amble.ait.registry.impl.SonicRegistry;
import dev.amble.ait.registry.impl.console.variant.ConsoleVariantRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;

public class LoyaltyHandler extends TardisComponent implements TardisTickable {
    private final Map<UUID, Loyalty> data;
    private boolean messageEnabled = true;

    public boolean isMessageEnabled() {
        return messageEnabled;
    }

    public void setMessageEnabled(boolean messageEnabled) {
        this.messageEnabled = messageEnabled;
    }

    public LoyaltyHandler(HashMap<UUID, Loyalty> data) {
        super(Id.LOYALTY);
        this.data = data;
    }

    public LoyaltyHandler() {
        this(new HashMap<>());
    }

    public Map<UUID, Loyalty> data() {
        return this.data;
    }

    public Loyalty get(class_1657 player) {
        return this.data.getOrDefault(player.method_5667(), new Loyalty(Loyalty.Type.NEUTRAL));
    }

    public Loyalty set(class_3222 player, Loyalty loyalty) {
        this.data.put(player.method_5667(), loyalty);
        this.unlock(player, loyalty);

        this.sync();
        return loyalty;
    }

    @Override
    public void tick(MinecraftServer server) {
        if (server.method_3780() % 40 != 0)
            return;

        for (class_3222 player : tardis.asServer().world().method_18456()) {
            Loyalty loyalty = this.get(player);

            if (!loyalty.isOf(Loyalty.Type.NEUTRAL))
                continue;

            if (ItemOpinionRegistry.getInstance().get(player.method_6047()).isPresent()) {
                ItemOpinion opinion = ItemOpinionRegistry.getInstance().get(player.method_6047()).get();
                tardis.opinions().contains(opinion);
                player.method_43496(class_2561.method_43469("ait.tardis.likes_item", true));
            }

            if (AITMod.RANDOM.nextInt(0, 20) != 14)
                continue;

            this.addLevel(player, 1);
        }
    }

    public void update(class_3222 player, Function<Loyalty, Loyalty> consumer) {
        Loyalty current = this.get(player);
        current = consumer.apply(current);

        this.set(player, current);
    }

    public void unlock(class_3222 player, Loyalty loyalty) {
        ServerTardis tardis = (ServerTardis) this.tardis;

        boolean playSound = messageEnabled;

        if (playSound) {
            playSound = ConsoleVariantRegistry.getInstance().tryUnlock(tardis, loyalty,
                    schema -> this.playUnlockEffects(player, schema));
            playSound = DesktopRegistry.getInstance().tryUnlock(tardis, loyalty,
                    schema -> this.playUnlockEffects(player, schema)) || playSound;
            playSound = ExteriorVariantRegistry.getInstance().tryUnlock(tardis, loyalty,
                    schema -> this.playUnlockEffects(player, schema)) || playSound;
            playSound = SonicRegistry.getInstance().tryUnlock(tardis, loyalty,
                    schema -> this.playUnlockEffects(player, schema)) || playSound;
        }

        if (playSound)
            player.method_51469().method_8396(null, player.method_24515(), AITSounds.LOYALTY_UP,
                    class_3419.field_15248, 0.2F, 1.0F);

        if (loyalty.isOf(Loyalty.Type.OWNER))
            TardisCriterions.REACH_OWNER.trigger(player);
        else if (loyalty.isOf(Loyalty.Type.PILOT))
            TardisCriterions.REACH_PILOT.trigger(player);
    }

    private void playUnlockEffects(class_3222 player, Nameable nameable) {
        class_2561 nameText = nameable.text().method_27661().method_27692(class_124.field_1060);

        class_2561 unlockedMessage;
        if (nameable instanceof SonicSchema) {
            unlockedMessage = class_2561.method_43469("message.ait.unlocked_sonic", nameText).method_27692(class_124.field_1068);
        } else if (nameable instanceof ConsoleVariantSchema) {
            unlockedMessage = class_2561.method_43469("message.ait.unlocked_console", nameText).method_27692(class_124.field_1068);
        } else if (nameable instanceof TardisDesktopSchema) {
            unlockedMessage = class_2561.method_43469("message.ait.unlocked_interior", nameText).method_27692(class_124.field_1068);
        } else if (nameable instanceof ExteriorVariantSchema) {
            unlockedMessage = class_2561.method_43469("message.ait.unlocked_exterior", nameText).method_27692(class_124.field_1068);
        } else {
            unlockedMessage = class_2561.method_43469("message.ait.unlocked", nameText).method_27692(class_124.field_1068);
        }

        player.method_7353(unlockedMessage, false);
    }


    public void addLevel(class_3222 player, int level) {
        this.update(player, loyalty -> loyalty.add(level));
    }

    public void subLevel(class_3222 player, int level) {
        this.addLevel(player, -level);
    }

    public class_3222 getLoyalPlayerInside() {
        if (!(this.tardis instanceof ServerTardis serverTardis))
            return null;

        class_3222 highest = null;
        int highestLoyalty = 0;

        for (class_3222 player : serverTardis.world().method_18456()) {
            if (highest == null) {
                highest = player;
                highestLoyalty = this.get(highest).level();
                continue;
            }

            int found = this.get(player).level();

            if (found > highestLoyalty) {
                highest = player;
                highestLoyalty = found;
            }
        }

        return highest;
    }

    public void sendMessageToPilot(class_2561 text) {
        class_3222 player = this.getLoyalPlayerInside();

        if (player == null)
            return;

        player.method_7353(text, true);
    }
}
