package dev.amble.ait.core.tardis.handler;

import static dev.amble.ait.core.engine.SubSystem.Id.GRAVITATIONAL;

import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.common.TaskStage;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_7718;
import net.minecraft.server.MinecraftServer;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.engine.impl.GravitationalCircuit;
import dev.amble.ait.core.entities.FallingTardisEntity;
import dev.amble.ait.core.entities.FlightTardisEntity;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;

public class RealFlightHandler extends KeyedTardisComponent implements TardisTickable {

    private static final class_2960 ENTER_FLIGHT = AITMod.id("enter_flight");
    private static final class_2960 EXIT_FLIGHT = AITMod.id("exit_flight");

    private static final BoolProperty IS_FALLING = new BoolProperty("falling", false);
    private static final BoolProperty FLYING = new BoolProperty("flying", false);
    private static final BoolProperty SHOULD_FALL = new BoolProperty("should_fall", false);

    private final BoolValue falling = IS_FALLING.create(this);
    private final BoolValue flying = FLYING.create(this);
    private final BoolValue shouldFall = SHOULD_FALL.create(this);

    static {
        TardisEvents.DEMAT.register(tardis -> {
            tardis.flight().flying.set(false);
            return tardis.flight().falling().get() ? TardisEvents.Interaction.FAIL : TardisEvents.Interaction.PASS;
        });
    }

    public RealFlightHandler() {
        super(Id.FLIGHT);
    }

    @Override
    public void onLoaded() {
        falling.of(this, IS_FALLING);
        flying.of(this, FLYING);
        shouldFall.of(this, SHOULD_FALL);
    }

    public boolean isFlying() {
        return flying.get();
    }

    @Override
    public void tick(MinecraftServer server) {
        if (this.falling.get())
            this.tardis.door().setLocked(true);
    }

    public void tickFlight(class_3222 player) {
        tardis.travel().forcePosition(cached -> cached.pos(player.method_24515())
                .rotation((byte) class_7718.method_45479(player.method_36454())));
        if (player.field_6012 % 20 != 0) {
            GravitationalCircuit circuit = tardis.subsystems().get(GRAVITATIONAL);
            if (circuit.isEnabled()) {
                circuit.removeDurability(0.5f);
            }
        }
    }

    public void onLanding(class_3218 world, class_2338 pos) {
        this.tardis.travel().forcePosition(cached -> cached.world(world.method_27983()).pos(pos));

        this.falling.set(false);
        this.tardis.door().setLocked(this.tardis.door().previouslyLocked().get());
        this.tardis.door().setDeadlocked(false);

        world.method_45447(null, pos, AITSounds.LAND_THUD, class_3419.field_15245);

        tardis.getDesktop().playSoundAtEveryConsole(AITSounds.LAND_THUD, class_3419.field_15245);
        TardisEvents.LANDED.invoker().onLanded(tardis);
    }

    public void onStartFalling(class_3218 world, class_2680 state, class_2338 pos) {
        this.falling.set(true);
        TardisEvents.START_FALLING.invoker().onStartFall(tardis);

        FallingTardisEntity.spawnFromBlock(world, pos, state);
    }

    public void enterFlight(class_3222 player) {
        if (!AITMod.CONFIG.rwfEnabled) return;
        this.tardis.door().closeDoors();
        this.tardis().travel().autopilot(false);
        this.tardis.travel().handbrake(true);
        this.flying.set(true);

        FlightTardisEntity entity = FlightTardisEntity.createAndSpawn(
                player, this.tardis.asServer());

        TardisUtil.teleportOutside(tardis, player);

        Scheduler.get().runTaskLater(() -> {
            player.method_5804(entity);
            this.sendEnterFlightPacket(player);
        }, TaskStage.END_SERVER_TICK, TimeUnit.TICKS, 2);

        tardis.travel().finishDemat();
    }

    private void sendEnterFlightPacket(class_3222 player) {
        if (!AITMod.CONFIG.rwfEnabled) return;
        ServerPlayNetworking.send(player, ENTER_FLIGHT, PacketByteBufs.create());
  }

    public void exitFlight(class_3222 player) {
        this.flying.set(false);

        player.method_5648(false);
        player.method_5684(false);
        this.sendExitFlightPacket(player);

        tardis.travel().forcePosition(cached -> cached.rotation((byte) class_7718.method_45479(player.method_36454())));
        tardis.travel().placeExterior(false);

        tardis.travel().finishRemat();
    }

    private void sendExitFlightPacket(class_3222 player) {
        ServerPlayNetworking.send(player, EXIT_FLIGHT, PacketByteBufs.create());
    }

    public BoolValue falling() {
        return falling;
    }

    public BoolValue flying() {
        return flying;
    }

    public BoolValue shouldFall() {
        return shouldFall;
    }
}
