package dev.amble.ait.core.tardis.handler;

import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;

public class SelfDestructHandler extends KeyedTardisComponent implements TardisTickable {

    private static final BoolProperty QUEUED = new BoolProperty("queued");
    private final BoolValue queued = QUEUED.create(this);

    @Exclude
    private boolean destructing;

    public SelfDestructHandler() {
        super(Id.SELF_DESTRUCT);
    }

    @Override
    public void onLoaded() {
        queued.of(this, QUEUED);
        this.destructing = false;
    }

    public void boom() {
        if (this.isQueued() || !this.canSelfDestruct())
            return;

        this.queued.set(true);
        this.tardis.alarm().enable();
    }

    private void complete() {
        CachedDirectedGlobalPos exterior = tardis.travel().position();
        class_3218 world = exterior.getWorld();
        class_2338 pos = exterior.getPos();

        this.queued.set(false);

        AITMod.LOGGER.warn("Tardis {} has self destructed, expect lag.", tardis.getUuid());
        world.method_8503().method_40000(() -> ServerTardisManager.getInstance().remove(world.method_8503(), tardis.asServer()));

        world.method_8454(null, null, TardisUtil.EXPLOSION_BEHAVIOR, pos.method_10263(), pos.method_10264(), pos.method_10260(), 50, TardisUtil.doCreateFire(world),
                class_1937.class_7867.field_40890);
        world.method_14199(class_2398.field_11221, pos.method_10263(), pos.method_10264(), pos.method_10260(), 10, 1, 1, 1, 1);
        world.method_14199(class_2398.field_11204, pos.method_10263(), pos.method_10264(), pos.method_10260(), 100, 1, 1, 1, 1);
        world.method_14199(class_2398.field_11237, pos.method_10263(), pos.method_10264(), pos.method_10260(), 250, 1, 1, 1, 1);
        world.method_14199(class_2398.field_11240, pos.method_10263(), pos.method_10264(), pos.method_10260(), 50, 1, 1, 1, 1);
        world.method_14199(class_2398.field_22246, pos.method_10263(), pos.method_10264(), pos.method_10260(), 25, 1, 1, 1, 1);
        world.method_14199(class_2398.field_27783, pos.method_10263(), pos.method_10264(), pos.method_10260(), 10, 1, 1, 1, 1);
        world.method_14199(class_2398.field_17430, pos.method_10263(), pos.method_10264(), pos.method_10260(), 500, 1, 1, 1, 1);
        world.method_8396(null, pos, AITSounds.GROAN, class_3419.field_15245, 10f, 0.7f);

        ServerTardisManager.getInstance().remove(world.method_8503(), tardis.asServer());
    }

    public boolean isQueued() {
        return queued.get();
    }

    private boolean canSelfDestruct() {
        return tardis.travel().isLanded();
    }

    private void warnPlayers() {
        for (class_1657 player : this.tardis.asServer().world().method_18456()) {
            player.method_7353(class_2561.method_43471("tardis.message.self_destruct.warning").method_27692(class_124.field_1061),
                    true);
        }
    }

    @Override
    public void tick(MinecraftServer server) {
        if (!this.isQueued())
            return;

        if (!this.canSelfDestruct()) {
            this.queued.set(false);

            tardis.alarm().disable();
            return;
        }

        if (!TardisUtil.isInteriorEmpty(tardis.asServer())) {
            warnPlayers();
            return;
        }

        if (!this.destructing) {
            tardis.getDesktop().startQueue(true);

            tardis.travel().setTemporaryAnimation(AITMod.id("self_destruct"));
            tardis.travel().onAnimationComplete(this::complete);

            this.destructing = true;
        }
    }
}
