package dev.amble.ait.core.tardis.handler;

import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1676;
import net.minecraft.class_1685;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.AITDimensions;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.AITStatusEffects;
import dev.amble.ait.core.tardis.control.impl.SecurityControl;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;

public class ShieldHandler extends KeyedTardisComponent implements TardisTickable {
    private static final BoolProperty IS_SHIELDED = new BoolProperty("is_shielded", false);
    private final BoolValue isShielded = IS_SHIELDED.create(this);
    public static BoolProperty IS_VISUALLY_SHIELDED = new BoolProperty("is_visually_shielded", false);
    private final BoolValue isVisuallyShielded = IS_VISUALLY_SHIELDED.create(this);

    private int shieldAmbienceTicks = 0;

    public ShieldHandler() {
        super(Id.SHIELDS);
    }

    @Override
    public void onLoaded() {
        isShielded.of(this, IS_SHIELDED);
        isVisuallyShielded.of(this, IS_VISUALLY_SHIELDED);
    }

    public BoolValue shielded() {
        return isShielded;
    }

    public BoolValue visuallyShielded() {
        return isVisuallyShielded;
    }

    public void enable() {
        this.shielded().set(true);
        TardisEvents.TOGGLE_SHIELDS.invoker().onShields(this.tardis, true, this.visuallyShielded().get());
    }

    public void disable() {
        this.shielded().set(false);
        TardisEvents.TOGGLE_SHIELDS.invoker().onShields(this.tardis, false, this.visuallyShielded().get());
    }

    public void toggle() {
        if (this.shielded().get())
            this.disable();
        else
            this.enable();
    }

    public void enableVisuals() {
        this.visuallyShielded().set(true);
        TardisEvents.TOGGLE_SHIELDS.invoker().onShields(this.tardis, this.shielded().get(), true);
    }

    public void disableVisuals() {
        this.visuallyShielded().set(false);
        TardisEvents.TOGGLE_SHIELDS.invoker().onShields(this.tardis, this.shielded().get(), false);
    }

    public void toggleVisuals() {
        if (this.visuallyShielded().get())
            this.disableVisuals();
        else
            this.enableVisuals();
    }

    public void disableAll() {
        this.disableVisuals();
        this.disable();
    }

    @Override
    public void tick(MinecraftServer server) {
        if (!this.shielded().get() || !this.tardis.subsystems().shields().isEnabled() || this.tardis().subsystems().shields().isBroken())
            return;

        TravelHandler travel = tardis.travel();

        if (!this.tardis.fuel().hasPower())
            this.disableAll();

        if (travel.getState() == TravelHandlerBase.State.FLIGHT)
            return;

        tardis.removeFuel(2 * travel.instability()); // idle drain of 2 fuel per tick
        CachedDirectedGlobalPos globalExteriorPos = travel.position();

        class_1937 world = globalExteriorPos.getWorld();
        class_2338 exteriorPos = globalExteriorPos.getPos();

        if (this.visuallyShielded().get()) {
            shieldAmbienceTicks++;
            if (shieldAmbienceTicks >= 44) {
                shieldAmbienceTicks = 0;
                tardis.getExterior().playSound(AITSounds.SHIELD_AMBIANCE, class_3419.field_15245, 2f, 0.7f);
            }
        }
        world.method_8335(null, new class_238(exteriorPos).method_1014(8f)).stream()
                .filter(entity -> entity.method_5810() || entity instanceof class_1676)
                .forEach(entity -> {
                    if (entity instanceof class_3222 player) {
                        if (!canPush(player)) {
                            if (entity.method_5869()) {
                                player.method_6092(
                                        new class_1293(class_1294.field_5923, 15, 3, true, false, false));
                            }
                            if (entity.method_37908().method_27983().equals(AITDimensions.SPACE)) {
                                player.method_6092(
                                        new class_1293(AITStatusEffects.OXYGENATED, 20, 1, true, false));
                            }
                            return;
                        }
                    }
                    if (this.visuallyShielded().get()) {
                        class_243 centerExteriorPos = exteriorPos.method_46558();

                        if (entity.method_5707(centerExteriorPos) <= 8f) {
                            class_243 motion = entity.method_24515().method_46558().method_1020(centerExteriorPos).method_1029()
                                    .method_1021(0.1f);

                            if (entity instanceof class_1676 projectile) {
                                class_2338 pos = projectile.method_24515();

                                if (projectile instanceof class_1685) {
                                    projectile.method_18798().method_1019(motion.method_1021(2f));

                                    world.method_8396(null, pos, class_3417.field_15213, class_3419.field_15245, 1f,
                                            1f);
                                    return;
                                }

                                world.method_8396(null, pos, class_3417.field_14821, class_3419.field_15245, 1f,
                                        1f);

                                projectile.method_31472();
                                return;
                            }

                            entity.method_18799(entity.method_18798().method_1019(motion.method_1021(2f)));

                            entity.field_6007 = true;
                            entity.field_6037 = true;
                        }
                    }
                });
    }

    /**
     * Checks
     * - Loyalty > COMPANION
     * - Has linked key
     * @param entity the entity to check
     * @return true if the entity will be repulsed by the shield
     */
    private boolean canPush(class_3222 entity) {
        boolean companion = tardis.loyalty().get(entity).isOf(Loyalty.Type.COMPANION);

        return !(companion || SecurityControl.hasMatchingKey(entity, this.tardis()));
    }
}
