package dev.amble.ait.core.tardis.handler;

import java.util.Objects;
import java.util.UUID;

import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.item.SiegeTardisItem;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.data.properties.Property;
import dev.amble.ait.data.properties.Value;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;

public class SiegeHandler extends KeyedTardisComponent implements TardisTickable {

    public static final class_2960 DEFAULT_TEXTURRE = new class_2960(AITMod.MOD_ID,
            "textures/blockentities/exteriors/siege_mode/siege_mode.png");
    public static final class_2960 BRICK_TEXTURE = new class_2960(AITMod.MOD_ID,
            "textures/blockentities/exteriors/siege_mode/siege_mode_brick.png");
    public static final class_2960 COMPANION_TEXTURE = new class_2960(AITMod.MOD_ID,
            "textures/blockentities/exteriors/siege_mode/companion_cube.png");
    public static final class_2960 APERTURE_TEXTURE = new class_2960(AITMod.MOD_ID,
            "textures/blockentities/exteriors/siege_mode/weighted_cube.png");

    private static final Property<UUID> HELD_KEY = new Property<>(Property.UUID, "siege_held_uuid");
    private static final Property<class_2960> TEXTURE = new Property<>(Property.IDENTIFIER, "texture", DEFAULT_TEXTURRE);

    private static final BoolProperty ACTIVE = new BoolProperty("siege_mode", false);

    private final Value<UUID> heldKey = HELD_KEY.create(this);
    private final BoolValue active = ACTIVE.create(this);
    private final Value<class_2960> texture = TEXTURE.create(this);

    private int siegeTime;

    public SiegeHandler() {
        super(Id.SIEGE);
    }

    static {
        TardisEvents.DEMAT.register(tardis -> tardis.siege().isActive() ? TardisEvents.Interaction.FAIL : TardisEvents.Interaction.PASS);

        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 player = handler.method_32311();

            ServerTardisManager.getInstance().forEach(tardis -> {
                if (!tardis.siege().isActive())
                    return;

                if (!Objects.equals(tardis.siege().getHeldPlayerUUID(), player.method_5667()))
                    return;

                for (class_1799 itemStack : player.method_31548().field_7547) {
                    if (itemStack.method_31574(AITItems.SIEGE_ITEM)) {
                        if (tardis.getUuid().equals(SiegeTardisItem.getTardisIdStatic(itemStack))) {
                            player.method_31548().method_5447(player.method_31548().method_7395(itemStack), class_1802.field_8162.method_7854());
                        }
                    }
                }
                SiegeTardisItem.placeTardis(tardis, SiegeTardisItem.fromEntity(player));
            });
        });
    }

    @Override
    public void onLoaded() {
        active.of(this, ACTIVE);
        heldKey.of(this, HELD_KEY);
        texture.of(this, TEXTURE);

        // fix old data using new UUID(0, 0) instead of null.
        UUID held = this.getHeldPlayerUUID();

        if (held != null && held.getMostSignificantBits() == 0 && held.getLeastSignificantBits() == 0)
            this.setSiegeBeingHeld(null);
    }

    public boolean isActive() {
        return active.get();
    }

    public boolean isSiegeBeingHeld() {
        return this.isActive() && heldKey.get() != null;
    }

    public UUID getHeldPlayerUUID() {
        return heldKey.get();
    }

    public void setSiegeBeingHeld(UUID playerId) {
        if (playerId != null) {
            this.tardis.door().closeDoors();
            this.tardis.door().setLocked(true);
            this.tardis.alarm().enable();
        }

        this.heldKey.set(playerId);
    }

    public void setActive(boolean siege) {
        if (this.tardis.getFuel() <= (0.01 * FuelHandler.TARDIS_MAX_FUEL))
            return; // The required amount of fuel to enable/disable siege mode

        class_3414 sound;

        if (siege) {
            sound = AITSounds.SIEGE_ENABLE;
            this.tardis.door().closeDoors();
            this.tardis.door().setLocked(true);
            this.tardis.door().setDeadlocked(true);

            this.tardis.fuel().disablePower();

            TardisUtil.giveEffectToInteriorPlayers(this.tardis.asServer(),
                    new class_1293(class_1294.field_5916, 100, 0, false, false));
        } else {
            sound = AITSounds.SIEGE_DISABLE;
            this.tardis.door().setDeadlocked(false);
            this.tardis.door().setLocked(false);

            this.tardis.alarm().disable();

            if (this.tardis.getExterior().findExteriorBlock().isEmpty()) {
                this.tardis.travel().placeExterior(false);
            }

            this.siegeTime = 0;
        }

        tardis.getDesktop().playSoundAtEveryConsole(sound, class_3419.field_15245, 3f, 1f);

        this.tardis.removeFuel(0.01 * FuelHandler.TARDIS_MAX_FUEL * this.tardis.travel().instability());
        this.active.set(siege);

        TardisEvents.TOGGLE_SIEGE.invoker().onSiege(this.tardis, siege);
    }

    @Override
    public void tick(MinecraftServer server) {
        if (!this.active.get())
            return;

        this.siegeTime += 1;

        if (server.method_3780() % 10 == 0)
            return;

        boolean freeze = this.siegeTime > 60 * 20 && !this.isSiegeBeingHeld()
                && !this.tardis.subsystems().lifeSupport().isEnabled();

        this.tardis.asServer().world().method_18456().forEach(player -> {
            if (!player.method_5805() || !player.method_32316())
                return;

            if (freeze) {
                this.freeze(player);
            } else {
                this.unfreeze(player);
            }
        });
    }

    private void freeze(class_3222 player) {
        int m = player.method_32312();
        if (m < 0) player.method_32317(5);
        player.method_32317(Math.min(player.method_32315(), m + 5));
    }

    private void unfreeze(class_3222 player) {
        if (player.method_32312() > player.method_32315())
            player.method_32317(0);
    }

    public Value<class_2960> texture() {
        return texture;
    }
}
