package dev.amble.ait.core.tardis.handler;

import java.util.function.Consumer;

import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.ArtronHolderItem;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.data.properties.Property;
import dev.amble.ait.data.properties.Value;
import dev.amble.ait.registry.impl.SonicRegistry;

public class SonicHandler extends KeyedTardisComponent implements ArtronHolderItem, TardisTickable {

    public static final class_2960 CHANGE_SONIC = AITMod.id("change_sonic");

    private static final Property<class_1799> EXTERIOR_SONIC = new Property<>(Property.ITEM_STACK, "exterior_sonic");

    private final Value<class_1799> exteriorSonic = EXTERIOR_SONIC.create(this); // The current sonic in the exterior's
                                                                                // keyhole
    static {
        ServerPlayNetworking.registerGlobalReceiver(CHANGE_SONIC,
                ServerTardisManager.receiveTardis((tardis, server, player, handler, buf, responseSender) -> {
                    class_2960 id = buf.method_10810();
                    class_2338 pos = buf.method_10811();
                    server.execute(() -> {
                        if (!tardis.isUnlocked(SonicRegistry.getInstance().get(id))) return;

                        if (!(tardis.world().method_8321(pos) instanceof ConsoleBlockEntity consoleBlockEntity)) return;

                        SonicItem.setSchema(consoleBlockEntity.getSonicScrewdriver(), id);});
                }));
        TardisEvents.DEMAT.register(tardis ->
                tardis.sonic().getExteriorSonic() != null ? TardisEvents.Interaction.FAIL : TardisEvents.Interaction.PASS);
    }

    public SonicHandler() {
        super(Id.SONIC);
    }

    @Override
    public void onLoaded() {
        exteriorSonic.of(this, EXTERIOR_SONIC);
    }

    public class_1799 getExteriorSonic() {
        return this.exteriorSonic.get();
    }


    public void insertExteriorSonic(class_1799 sonic) {
        insertAnySonic(this.exteriorSonic, sonic, stack -> spawnItem(this.tardis.travel().position(), stack));
    }

    public class_1799 takeExteriorSonic() {
        return takeAnySonic(this.exteriorSonic);
    }

    private static class_1799 takeAnySonic(Value<class_1799> value) {
        class_1799 result = value.get();
        value.set((class_1799) null);

        return result;
    }

    private static void insertAnySonic(Value<class_1799> value, class_1799 sonic, Consumer<class_1799> spawner) {
        value.flatMap(stack -> {
            if (stack != null)
                spawner.accept(stack);

            return sonic;
        });
    }

    public static void spawnItem(class_1937 world, class_2338 pos, class_1799 sonic) {
        class_1542 entity = new class_1542(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), sonic);
        world.method_8649(entity);
    }

    public static void spawnItem(CachedDirectedGlobalPos cached, class_1799 sonic) {
        spawnItem(cached.getWorld(), cached.getPos(), sonic);
    }

    @Override
    public double getMaxFuel(class_1799 stack) {
        return SonicItem.MAX_FUEL;
    }

    @Override
    public void tick(MinecraftServer server) {
        if (server.method_3780() % 10 != 0)
            return;

        class_1799 exteriorSonic = this.exteriorSonic.get();

        if (exteriorSonic != null) {
            ServerTardis tardis = this.tardis.asServer();

            TardisCrashHandler crash = tardis.crash();
            boolean isToxic = crash.isToxic();
            boolean isUnstable = crash.isUnstable();
            int repairTicks = crash.getRepairTicks();

            if (!isToxic && !isUnstable)
                return;

            crash.setRepairTicks(repairTicks <= 0 ? 0 : repairTicks - 5);

            // TODO
            /*
            if () {
                tardis.travel().position().getWorld().playSound(null, tardis.travel().position().getPos(),
                        AITSounds.SONIC_USE, SoundCategory.BLOCKS, 0.5f, 1f);
            }
             */

            this.removeFuel(10, exteriorSonic);
        }
    }
}
