package dev.amble.ait.core.tardis.handler;

import java.util.Optional;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.core.item.WaypointItem;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.Waypoint;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;

public class WaypointHandler extends KeyedTardisComponent {
    public static final BoolProperty HAS_CARTRIDGE = new BoolProperty("has_cartridge", false);
    private final BoolValue hasCartridge = HAS_CARTRIDGE.create(this);
    private Waypoint current; // The current waypoint in the slot ( tried to make it optional, but that
    // caused a
    // gson crash )

    public WaypointHandler() {
        super(Id.WAYPOINTS);
    }

    @Override
    public void onLoaded() {
        hasCartridge.of(this, HAS_CARTRIDGE);
    }

    public boolean hasCartridge() {
        return hasCartridge.get();
    }

    public void setHasCartridge() {
        hasCartridge.set(true);
    }

    private void clearCartridge() {
        hasCartridge.set(false);
    }

    /**
     * Sets the new waypoint
     *
     * @return The optional of the previous waypoint
     */
    public Optional<Waypoint> set(Waypoint var, class_2338 console, boolean spawnItem) {
        Optional<Waypoint> prev = Optional.ofNullable(this.current);

        if (spawnItem && this.current != null)
            this.spawnItem(console, prev.get());

        this.current = var;
        return prev;
    }

    public Waypoint get() {
        return this.current;
    }

    public boolean hasWaypoint() {
        return this.current != null;
    }

    public void clear(class_2338 console, boolean spawnItem) {
        this.set(null, console, spawnItem);
        this.clearCartridge();
    }

    public boolean loadWaypoint() {
        if (!this.hasWaypoint())
            return false;

        CachedDirectedGlobalPos cachedPos = this.get().getPos();

        if (cachedPos == null || !this.hasWaypoint())
            return false;

        if (cachedPos.getWorld() instanceof TardisServerWorld) {
            cachedPos = CachedDirectedGlobalPos.create(TardisServerWorld.field_25179, cachedPos.getPos(), cachedPos.getRotation());
        }

        tardis.travel().destination(cachedPos);
        return true;
    }

    public void spawnItem(class_2338 console) {
        if (!this.hasWaypoint())
            return;

        this.spawnItem(console, this.get());
        this.clear(console, false);
    }

    public void spawnItem(class_2338 console, Waypoint waypoint) {
        if (!this.hasCartridge())
            return;

        class_1542 entity = new class_1542(tardis.asServer().world(), console.method_10263(), console.method_10264(),
                console.method_10260(), createWaypointItem(waypoint));

        tardis.asServer().world().method_8649(entity);
    }

    public static class_1799 createWaypointItem(Waypoint waypoint) {
        return WaypointItem.create(waypoint);
    }
}
