package dev.amble.ait.core.tardis.handler.travel;

import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.drtheo.queue.api.ActionQueue;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisDesktop;
import dev.amble.ait.core.tardis.handler.ServerAlarmHandler;
import dev.amble.ait.core.tardis.handler.TardisCrashHandler;
import dev.amble.ait.data.properties.bool.BoolValue;

public sealed interface CrashableTardisTravel permits TravelHandler {

    Tardis tardis();

    TravelHandlerBase.State getState();

    void resetHammerUses();

    int getHammerUses();

    boolean isCrashing();

    void setCrashing(boolean value);

    int speed();

    void speed(int speed);

    BoolValue antigravs();

    Optional<ActionQueue> forceRemat();

    CachedDirectedGlobalPos position();

    CachedDirectedGlobalPos getProgress();

    void destination(CachedDirectedGlobalPos cached);

    /**
     * Performs a crash for the Tardis. If the Tardis is not in flight state, the
     * crash will not be executed.
     */
    default void crash() {
        if (this.getState() != TravelHandler.State.FLIGHT || this.isCrashing())
            return;

        Tardis tardis = this.tardis();
        int power = this.speed() + this.getHammerUses() + 1;

        if (tardis.sequence().hasActiveSequence())
            tardis.sequence().setActiveSequence(null, true);

        class_3218 world = tardis.asServer().world();

        tardis.getDesktop().getConsolePos().forEach(console -> {
            startCrashEffects(tardis, console);
        });

        Random random = AITMod.RANDOM;

        for (class_3222 player : world.method_18456()) {
            float xVel = random.nextFloat(-2f, 3f);
            float yVel = random.nextFloat(-1f, 2f);
            float zVel = random.nextFloat(-2f, 3f);

            player.method_18800(xVel * power, yVel * power, zVel * power);
            player.method_6092(new class_1293(class_1294.field_5919, 40 * power, 1, true, false, false));
            player.method_6092(new class_1293(class_1294.field_5911, 40 * power, 1, true, false, false));
            player.method_6092(new class_1293(class_1294.field_5916, 40 * power, 2, true, false, false));

            int damage = (int) Math.round(0.5 * power);
            player.method_5643(world.method_48963().method_48830(), damage);
        }

        tardis.door().setLocked(true);
        tardis.alarm().enable(ServerAlarmHandler.AlarmType.CRASHING);
        this.antigravs().set(false);
        this.speed(0);
        tardis.removeFuel(700 * power);
        this.resetHammerUses();
        this.setCrashing(true);
        this.forceRemat();

        int repairTicks = 1200 * power;
        tardis.crash().setRepairTicks(repairTicks);

        if (repairTicks > TardisCrashHandler.UNSTABLE_TICK_START_THRESHOLD) {
            tardis.crash().setState(TardisCrashHandler.State.TOXIC);
        } else {
            tardis.crash().setState(TardisCrashHandler.State.UNSTABLE);
        }

        TardisEvents.CRASH.invoker().onCrash(tardis);
    }

    default void startCrashEffects(Tardis tardis, class_2338 console) {
        class_3218 world = tardis.asServer().world();
        TardisDesktop.playSoundAtConsole(world, console, class_3417.field_15152, class_3419.field_15245, 3f, 1f);
    }
}