package dev.amble.ait.core.tardis.handler.travel;

import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.util.AsyncLocatorUtil;

public class TravelUtil {

    private static final int BASE_FLIGHT_TICKS = 5 * 20;

    public static void randomPos(Tardis tardis, int limit, int max, Consumer<CachedDirectedGlobalPos> consumer) {
        TravelHandler travel = tardis.travel();

        CompletableFuture<Void> future = CompletableFuture.supplyAsync(() -> {
            CachedDirectedGlobalPos dest = travel.destination();
            class_3218 world = dest.getWorld();

            int posX = dest.getPos().method_10263();
            int posZ = dest.getPos().method_10260();

            for (int i = 0; i <= limit; i++) {
                dest = dest.pos(
                        world.field_9229.method_43056()
                                ? world.field_9229.method_43048(max) == 0 ? posX + 1 : posX + world.field_9229.method_43048(max)
                                : world.field_9229.method_43048(max) == -0 ? posX - 1 : posX - world.field_9229.method_43048(max),
                        dest.getPos().method_10264(),
                        world.field_9229.method_43056()
                                ? world.field_9229.method_43048(max) == 0 ? posZ + 1 : posZ + world.field_9229.method_43048(max)
                                : world.field_9229.method_43048(max) == -0 ? posZ - 1 : posZ - world.field_9229.method_43048(max));
            }

            return dest;
        }).thenAccept(consumer);

        AsyncLocatorUtil.LOCATING_EXECUTOR_SERVICE.submit(() -> future);
    }

    public static void travelTo(Tardis tardis, CachedDirectedGlobalPos pos) {
        TravelHandler travel = tardis.travel();

        travel.autopilot(true);
        travel.destination(pos);

        if (travel.getState() == TravelHandlerBase.State.LANDED)
            travel.dematerialize();
    }

    public static CachedDirectedGlobalPos getPositionFromPercentage(CachedDirectedGlobalPos source,
                                                                    CachedDirectedGlobalPos destination, int percentage) {
        // https://stackoverflow.com/questions/33907276/calculate-point-between-two-coordinates-based-on-a-percentage
        if (percentage == 0)
            return source;

        if (percentage == 100)
            return destination;

        float per = percentage / 100f;
        class_2338 pos = source.getPos();
        class_2338 diff = destination.getPos().method_10059(pos);

        return destination
                .pos(pos.method_10069((int) (diff.method_10263() * per), (int) (diff.method_10264() * per), (int) (diff.method_10260() * per)));
    }

    public static int getFlightDuration(CachedDirectedGlobalPos source, CachedDirectedGlobalPos destination) {
        float distance = class_3532.method_15355((float) source.getPos().method_10262(destination.getPos()));
        boolean hasDirChanged = !(source.getRotation() == destination.getRotation());
        boolean hasDimChanged = !(source.getDimension().equals(destination.getDimension()));

        return (int) (BASE_FLIGHT_TICKS + (distance / 10f) + (hasDirChanged ? 100 : 0) + (hasDimChanged ? 600 : 0));
    }

    public static CachedDirectedGlobalPos jukePos(CachedDirectedGlobalPos pos, int min, int max, int multiplier) {
        Random random = AITMod.RANDOM;
        multiplier *= random.nextInt(0, 2) == 0 ? 1 : -1;

        return pos.offset(random.nextInt(min, max) * multiplier, 0,
                random.nextInt(min, max) * multiplier);
    }

    public static CachedDirectedGlobalPos jukePos(CachedDirectedGlobalPos pos, int min, int max) {
        return jukePos(pos, min, max, 1);
    }
}
