package dev.amble.ait.core.tardis.util;

import java.util.*;
import java.util.stream.Stream;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.util.ServerLifecycleHooks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2767;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.link.LinkableItem;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;

public class NetworkUtil {

    public static <T> void send(class_3222 player, class_2540 buf, class_2960 id, Codec<T> codec, T t) {
        DataResult<class_2520> result = codec.encodeStart(class_2509.field_11560, t);
        class_2520 nbt = result.resultOrPartial(AITMod.LOGGER::error).orElseThrow();

        buf.method_10794((class_2487) nbt);
        send(player, id, buf);
    }

    public static void send(class_3222 player, class_2960 id, class_2540 buf) {
        if (player == null)
            return;

        ServerPlayNetworking.send(player, id, buf);
    }

    public static <T> T receive(Codec<T> codec, class_2540 buf) {
        return codec.decode(class_2509.field_11560, buf.method_10798())
                .resultOrPartial(AITMod.LOGGER::error)
                .orElseThrow().getFirst();
    }

    public static void sendToInterior(ServerTardis tardis, class_2960 id, class_2540 buf) {
        if (!tardis.hasWorld()) return;

        for (class_3222 player : tardis.world().method_18456()) {
            send(player, id, buf);
        }
    }

    public static Collection<class_3222> getLinkedPlayers(ServerTardis tardis) {
        List<class_3222> players = new ArrayList<>();

        for (class_3222 player : ServerLifecycleHooks.get().method_3760().method_14571()) {
            if (hasLinkedItem(tardis, player)) {
                players.add(player);
            }
        }

        return players;
    }

    public static boolean hasLinkedItem(Tardis tardis, class_3222 player) {
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7960())
                continue;

            if (!(stack.method_7909() instanceof LinkableItem))
                continue;

            if (!LinkableItem.isOfStatic(stack, tardis))
                continue;

            return true;
        }

        return false;
    }

    public static Set<ServerTardis> findLinkedItems(class_3222 player) {
        Set<ServerTardis> ids = new HashSet<>();

        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7960())
                continue;

            if (!(stack.method_7909() instanceof LinkableItem item))
                continue;

            Tardis tardis = item.getTardis(player.method_37908(), stack);

            if (tardis == null)
                continue;

            ids.add(tardis.asServer());
        }

        return ids;
    }

    public static Stream<class_3222> getSubscribedPlayers(ServerTardis tardis) {
        Stream<class_3222> result = tardis.hasWorld() ? tardis.world().method_18456().stream() : Stream.empty();
        CachedDirectedGlobalPos exteriorPos = tardis.travel().position();

        if (exteriorPos == null || exteriorPos.getWorld() == null)
            return result;

        class_1923 chunkPos = new class_1923(exteriorPos.getPos());
        return Stream.concat(result, PlayerLookup.tracking(exteriorPos.getWorld(), chunkPos).stream());
    }

    /**
     * plays a sound, ignoring whether it exists or not.
     */
    public static void playSound(class_5321<class_1937> worldKey, class_2338 pos, class_2960 soundId, class_3419 category, float volume) {
        if (!ServerLifecycleHooks.isServer()) return;

        class_6880<class_3414> soundEntry = class_6880.method_40223(class_3414.method_47908(soundId));
        long seed = ServerLifecycleHooks.get().method_30002().method_8409().method_43055();

        ServerLifecycleHooks.get()
                .method_3760()
                .method_14605(
                        null,
                        pos.method_10263(),
                        pos.method_10264(),
                        pos.method_10260(),
                        volume > 1.0F ? 16.0F * volume : 16.0F,
                        worldKey,
                        new class_2767(soundEntry, category, pos.method_10263(), pos.method_10264(), pos.method_10260(), volume, 1f, seed)
                );
    }

    @Environment(EnvType.CLIENT)
    public static boolean canClientSendPackets() {
        return class_310.method_1551().method_1562() != null;
    }
}
