package dev.amble.ait.core.tardis.util.network.s2c;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_310;
import net.minecraft.class_746;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;
import dev.amble.ait.core.tardis.Tardis;

public class BOTIDataS2CPacket implements FabricPacket {
    public static final PacketType<BOTIDataS2CPacket> TYPE = PacketType.create(AITMod.id("send_boti_data"), BOTIDataS2CPacket::new);

    private final class_2338 botiPos;
    public final class_2487 chunkData;

    public BOTIDataS2CPacket(class_2338 botiPos, class_2818 chunk, class_2338 targetPos) {
        this.botiPos = botiPos;
        this.chunkData = new class_2487();
        class_2487 blockStates = new class_2487();
        class_2487 blockEntities = new class_2487();
        class_1937 world = chunk.method_12200();
        int targetY = targetPos.method_10264();
        int baseY = targetY & ~15;
        int sectionIndex = chunk.method_31602(targetY);
        class_2826 section = chunk.method_38259(sectionIndex);
        class_1923 chunkPos = chunk.method_12004();

        try {
            List<class_2680> paletteList = new ArrayList<>();
            Map<class_2680, Integer> stateToIndex = new HashMap<>();
            paletteList.add(class_2246.field_10124.method_9564()); // Index 0 = air
            stateToIndex.put(class_2246.field_10124.method_9564(), 0);
            class_2680[][][] sectionStates = new class_2680[16][16][16];
            for (int y = 0; y < 16; y++) {
                for (int x = 0; x < 16; x++) {
                    for (int z = 0; z < 16; z++) {
                        class_2680 state = section.method_12254(x, y, z);
                        sectionStates[x][y][z] = state;
                        if (state != null && !state.method_26215() && !stateToIndex.containsKey(state)) {
                            stateToIndex.put(state, paletteList.size());
                            paletteList.add(state);
                        }
                    }
                }
            }

            // Build palette NBT
            class_2499 palette = new class_2499();
            for (class_2680 state : paletteList) {
                class_2487 stateNbt = (class_2487) class_2680.field_24734.encodeStart(class_2509.field_11560, state)
                        .result().orElseThrow(() -> new IllegalStateException("Failed to encode state " + state));
                palette.add(stateNbt);
            }

            int paletteSize = palette.size();
            int bitsPerEntry = Math.max(1, (int) Math.ceil(Math.log(paletteSize) / Math.log(2))); // Allow 1 bit for small palettes
            int entriesPerLong = 64 / bitsPerEntry;
            int dataLength = (int) Math.ceil(4096.0 / entriesPerLong); // 16x16x16 = 4096 entries

            // Build data array
            long[] data = new long[dataLength];
            for (int y = 0; y < 16; y++) {
                for (int z = 0; z < 16; z++) {
                    for (int x = 0; x < 16; x++) {
                        int index = y * 256 + z * 16 + x;
                        int longIndex = index / entriesPerLong;
                        int offset = (index % entriesPerLong) * bitsPerEntry;
                        class_2680 state = sectionStates[x][y][z];
                        int paletteIndex = stateToIndex.getOrDefault(state, 0); // Default to air
                        data[longIndex] |= ((long) paletteIndex & ((1L << bitsPerEntry) - 1)) << offset;
                    }
                }
            }

            // Collect block entity data
            for (int y = 0; y < 16; y++) {
                for (int x = 0; x < 16; x++) {
                    for (int z = 0; z < 16; z++) {
                        class_2338 worldPos = new class_2338(chunkPos.method_8326() + x, baseY + y, chunkPos.method_8328() + z);
                        class_2586 be = chunk.method_8321(worldPos);
                        if (be != null) {
                            class_2487 blockEntityNbt = be.method_38242();
                            String key = x + "_" + y + "_" + z;
                            blockEntities.method_10566(key, blockEntityNbt);
                        }
                    }
                }
            }

            blockStates.method_10566("palette", palette);
            blockStates.method_10564("data", data);
            blockStates.method_10569("bitsPerEntry", bitsPerEntry);
            this.chunkData.method_10566("block_states", blockStates);
            if (!blockEntities.method_33133()) {
                this.chunkData.method_10566("block_entities", blockEntities);
            }
        } catch (Exception e) {
            System.out.println("Exception in packet construction: " + e.getMessage());
            AITMod.LOGGER.atTrace();
            class_2499 palette = new class_2499();
            palette.add(class_2680.field_24734.encodeStart(class_2509.field_11560, class_2246.field_10340.method_9564())
                    .result().orElseThrow(() -> new IllegalStateException("Failed to encode stone state")));
            long[] fullData = new long[256];
            java.util.Arrays.fill(fullData, 0);
            blockStates.method_10566("palette", palette);
            blockStates.method_10564("data", fullData);
            System.out.println("Using fallback stone data due to serialization failure");
            this.chunkData.method_10566("block_states", blockStates);
        }
    }
    public BOTIDataS2CPacket(class_2338 botiPos, class_2487 chunkData) {
        this.botiPos = botiPos;
        this.chunkData = chunkData;
    }
    public BOTIDataS2CPacket(class_2540 buf) {
        this.botiPos = buf.method_10811();
        this.chunkData = buf.method_10798();
    }
    @Override
    public void write(class_2540 buf) {
        buf.method_10807(botiPos);
        buf.method_10794(chunkData);
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    @SuppressWarnings("unchecked")
    public <T> boolean handle(class_746 source, PacketSender response) {
        class_310 client = class_310.method_1551();
        class_1937 world = client.field_1687;

        if (world == null) return false;

        class_2586 exterior = world.method_8321(this.botiPos);

        if (exterior instanceof ExteriorBlockEntity exteriorBlockEntity) {
            if (!exteriorBlockEntity.isLinked()) return false;
            Tardis tardis = exteriorBlockEntity.tardis().get();
            // tardis.stats().updateChunkModel(exteriorBlockEntity, this.chunkData);
        }
        return true;
    }
}
