package dev.amble.ait.core.tardis.util.network.s2c;

import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;
import dev.amble.ait.core.tardis.Tardis;

public class BOTISyncS2CPacket implements FabricPacket {
    public static final PacketType<BOTISyncS2CPacket> TYPE = PacketType.create(AITMod.id("boti_sync"), BOTISyncS2CPacket::new);
    private final class_2338 pos;
    private final class_5321<class_1937> targetWorld;
    private final class_2338 targetPos;

    public BOTISyncS2CPacket(class_2338 pos, class_5321<class_1937> targetWorld, class_2338 targetPos) {
        this.pos = pos;
        this.targetWorld = targetWorld;
        this.targetPos = targetPos;
    }

    public BOTISyncS2CPacket(class_2540 buf) {
        this.pos = buf.method_10811();
        this.targetWorld = buf.method_44112(class_7924.field_41223);
        this.targetPos = buf.method_10811();
    }
    @Override
    public void write(class_2540 buf) {
        buf.method_10807(pos);
        buf.method_44116(targetWorld);
        buf.method_10807(targetPos);
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    @SuppressWarnings("unchecked")
    public <T> boolean handle(class_746 source, PacketSender response) {
        class_310 client = class_310.method_1551();
        class_1937 world = client.field_1687;
        if (world == null) return false;

        class_2586 exterior = world.method_8321(this.pos);

        if (exterior instanceof ExteriorBlockEntity exteriorBlockEntity) {
            if (!exteriorBlockEntity.isLinked()) return false;
            Tardis tardis = exteriorBlockEntity.tardis().get();
            // tardis.stats().setTargetWorld(exteriorBlockEntity, this.targetWorld, this.targetPos, false);
        }
        return true;
    }
}
