package dev.amble.ait.core.tardis.vortex.reference;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicReference;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.lib.api.Identifiable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.Nameable;
import dev.amble.ait.client.renderers.VortexRender;

public record VortexReference(class_2960 id, class_2960 texture, String name) implements Identifiable, Nameable {
    public static final Codec<VortexReference> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_2960.field_25139.fieldOf("id").forGetter(VortexReference::id),
            class_2960.field_25139.fieldOf("texture").forGetter(VortexReference::texture),
            Codec.STRING.optionalFieldOf("name", "").forGetter(VortexReference::name)
    ).apply(instance, VortexReference::new));

    public VortexReference {
        if (name.isEmpty()) {
            name = id.method_12832();
        }
    }

    public VortexReference(class_2960 id, class_2960 texture) {
        this(id, texture, id.method_12832());
    }

    @Environment(EnvType.CLIENT)
    public VortexRender toRender() {
        return VortexRender.getInstance(this);
    }

    public static VortexReference fromInputStream(InputStream stream) {
        return fromJson(JsonParser.parseReader(new InputStreamReader(stream)).getAsJsonObject());
    }

    public static VortexReference fromJson(JsonObject json) {
        AtomicReference<VortexReference> created = new AtomicReference<>();

        CODEC.decode(JsonOps.INSTANCE, json).get().ifLeft(planet -> created.set(planet.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack vortex: {}", err);
        });

        return created.get();
    }
}
