package dev.amble.ait.core.util;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.AITWorldOptions;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.core.AITDimensions;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.mixin.server.EnderDragonFightAccessor;
import dev.amble.lib.util.ServerLifecycleHooks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2783;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3612;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_6088;
import net.minecraft.server.MinecraftServer;
import java.util.*;

public class WorldUtil {

    private static final List<class_3218> PROJECTOR_WORLDS = new ArrayList<>();
    private static final List<class_3218> TRAVEL_WORLDS = new ArrayList<>();

    private static final Set<class_3218> RIFT_SPAWN_WORLDS = new HashSet<>();
    public static final List<class_3218> RIFT_DROP_WORLDS = new ArrayList<>();

    private static class_3218 OVERWORLD;
    private static class_3218 TIME_VORTEX;

    public static void init() {
        ServerLifecycleEvents.SERVER_STARTED.register(WorldUtil::generateWorldCache);
        ServerLifecycleEvents.SERVER_STOPPING.register(WorldUtil::clearWorldCache);

        ServerWorldEvents.UNLOAD.register((server, world) -> {
            if (world.method_27983() == class_1937.field_25179)
                OVERWORLD = null;

            if (world.method_27983() == AITDimensions.TIME_VORTEX_WORLD)
                TIME_VORTEX = null;
        });

        ServerWorldEvents.LOAD.register((server, world) -> {
            if (world.method_27983() == class_1937.field_25179)
                OVERWORLD = world;

            if (world.method_27983() == AITDimensions.TIME_VORTEX_WORLD)
                TIME_VORTEX = world;
        });

        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            OVERWORLD = server.method_30002();
            TIME_VORTEX = server.method_3847(AITDimensions.TIME_VORTEX_WORLD);
        });
    }

    public static class_3218 getOverworld() {
        return OVERWORLD;
    }

    public static class_3218 getTimeVortex() {
        return TIME_VORTEX;
    }

    private static void generateWorldCache(MinecraftServer server) {
        generateWorldCache(server, AITMod.CONFIG.projectorBlacklist, PROJECTOR_WORLDS);
        generateWorldCache(server, AITMod.CONFIG.travelBlacklist, TRAVEL_WORLDS);

        generateWorldCache(server, AITMod.CONFIG.riftSpawnBlacklist, RIFT_SPAWN_WORLDS);
        generateWorldCache(server, AITMod.CONFIG.riftDropBlacklist, RIFT_DROP_WORLDS);

        for (class_3218 riftSpawnable : RIFT_SPAWN_WORLDS) {
            if (riftSpawnable instanceof AITWorldOptions options)
                options.ait$setCanRiftsSpawn(true);
        }
    }

    private static void generateWorldCache(MinecraftServer server, List<String> raw, Collection<class_3218> worlds) {
        worlds.clear();

        Set<class_2960> ids = new HashSet<>();
        boolean blocksTardis = false;

        for (String rawId : raw) {
            if (rawId.equals("ait-tardis")) {
                blocksTardis = true;
                continue;
            }

            class_2960 id = class_2960.method_12829(rawId);

            if (id == null)
                continue;

            ids.add(id);
        }

        for (class_3218 world : server.method_3738()) {
            if (blocksTardis && TardisServerWorld.isTardisDimension(world))
                continue;

            class_2960 worldId = world.method_27983().method_29177();

            if (!ids.contains(worldId))
                worlds.add(world);
        }
    }

    private static void clearWorldCache(MinecraftServer server) {
        PROJECTOR_WORLDS.clear();
        TRAVEL_WORLDS.clear();

        RIFT_DROP_WORLDS.clear();
        RIFT_SPAWN_WORLDS.clear();
    }

    /**
     * @implNote This method uses a reference check (by `==`), instead of
     * {@link Object#equals(Object)}, as its {@link List} counterpart does.
     */
    public static int travelWorldIndex(class_3218 world) {
        for (int i = 0; i < TRAVEL_WORLDS.size(); i++) {
            if (world == TRAVEL_WORLDS.get(i))
                return i;
        }

        return -1;
    }

    public static boolean canRiftsSpawn(class_3218 world) {
        return world instanceof AITWorldOptions options && options.ait$canRiftsSpawn();
    }

    public static List<class_3218> getProjectorWorlds() {
        return PROJECTOR_WORLDS;
    }

    public static List<class_3218> getTravelWorlds() {
        return TRAVEL_WORLDS;
    }

    @Environment(EnvType.CLIENT)
    @SuppressWarnings("DataFlowIssue")
    public static String getName(class_310 client) {
        if (client.method_1542())
            return client.method_1576().method_27050(class_5218.field_24188).getParent().getFileName().toString();

        return client.method_1558().field_3761;
    }

    public static class_2561 worldText(class_5321<class_1937> key) {
        class_2561 translated = class_2561.method_48321(key.method_29177().method_42093("dimension"), fakeTranslate(key));

        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT)
            return hackWorldText(translated);

        return translated;
    }

    @Environment(EnvType.CLIENT)
    private static class_2561 hackWorldText(class_2561 existing) {
        if (ClientTardisUtil.getCurrentTardis() != null &&
                !ClientTardisUtil.getCurrentTardis().flight().isFlying() && ClientTardisUtil.getCurrentTardis().travel().inFlight()) {
            class_5321<class_1937> timeVortex = AITDimensions.TIME_VORTEX_WORLD;
            return
                    class_2561.method_48321(
                            timeVortex.method_29177().method_42093("dimension"),
                            fakeTranslate(timeVortex)).method_27693(" [").method_10852(existing).method_27693( "]");
        }

        return existing;
    }

    public static class_2561 worldText(class_5321<class_1937> key, boolean justToSeperate) {
        return class_2561.method_48321(key.method_29177().method_42093("dimension"), fakeTranslate(key));
    }

    private static String fakeTranslate(class_5321<class_1937> id) {
        return fakeTranslate(id.method_29177());
    }

    private static String fakeTranslate(class_2960 id) {
        return fakeTranslate(id.method_12832());
    }

    public static String fakeTranslate(String path) {
        // Split the string into words
        String[] words = path.split("_");

        // Capitalize the first letter of each word
        for (int i = 0; i < words.length; i++) {
            words[i] = words[i].substring(0, 1).toUpperCase() + words[i].substring(1).toLowerCase();
        }

        // Join the words back together with spaces
        return String.join(" ", words);
    }

    public static class_2561 rot2Text(int rotation) {
        String key = switch (rotation) {
            case 0 -> "direction.north";
            case 1, 2, 3 -> "direction.north_east";
            case 4 -> "direction.east";
            case 5, 6, 7 -> "direction.south_east";
            case 8 -> "direction.south";
            case 9, 10, 11 -> "direction.south_west";
            case 12 -> "direction.west";
            case 13, 14, 15 -> "direction.north_west";
            default -> null;
        };

        return class_2561.method_43471(key);
    }

    public static void onBreakHalfInCreative(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2756 doubleBlockHalf = state.method_11654(class_2741.field_12533);

        if (doubleBlockHalf != class_2756.field_12609)
            return;

        class_2338 blockPos = pos.method_10074();
        class_2680 blockState = world.method_8320(blockPos);

        if (blockState.method_27852(state.method_26204())
                && blockState.method_11654(class_2741.field_12533) == class_2756.field_12607) {
            class_2680 withFluid = blockState.method_26227().method_39360(class_3612.field_15910)
                    ? class_2246.field_10382.method_9564()
                    : class_2246.field_10124.method_9564();

            world.method_8652(blockPos, withFluid, 35);
            world.method_8444(player, class_6088.field_31144, blockPos, class_2248.method_9507(blockState));
        }
    }

    public static boolean isEndDragonDead() {
        class_3218 end = ServerLifecycleHooks.get().method_3847(class_1937.field_25181);
        if (end == null) return true;
        return ((EnderDragonFightAccessor) end.method_29198()).getDragonKilled();
    }

    public static void teleportToWorld(class_3222 player, class_3218 target, class_243 pos, float yaw, float pitch) {
        player.method_14251(target, pos.field_1352, pos.field_1351, pos.field_1350, yaw, pitch);
        player.method_7255(0);

        player.method_6026().forEach(effect -> player.field_13987.method_14364(
                new class_2783(player.method_5628(), effect)));
    }
}
