package dev.amble.ait.core.world;

import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.tardis.util.NetworkUtil;
import dev.amble.ait.data.landing.LandingPadRegion;

@SuppressWarnings("UnstableApiUsage")
public class LandingPadManager {

    private static final AttachmentType<LandingPadRegion> PERSISTENT = AttachmentRegistry.createPersistent(
            AITMod.id("landing_pads"), LandingPadRegion.CODEC
    );

    public static void init() {

    }

    private final class_3218 world;

    public LandingPadManager(class_3218 world) {
        this.world = world;
    }

    @Nullable public LandingPadRegion getRegion(class_1923 pos) {
        class_2791 chunk = this.world.method_8402(pos.field_9181, pos.field_9180, class_2806.field_12803, true);

        if (chunk == null)
            return null;

        return chunk.getAttached(PERSISTENT);
    }

    @Nullable public LandingPadRegion getRegion(long pos) {
        return this.getRegion(new class_1923(pos));
    }

    @Nullable public LandingPadRegion getRegionAt(class_2338 pos) {
        return this.getRegion(new class_1923(pos));
    }

    private LandingPadRegion claim(class_1923 pos, int y) {
        class_2818 chunk = this.world.method_8497(pos.field_9181, pos.field_9180);

        if (chunk.hasAttached(PERSISTENT))
            throw new IllegalStateException("Region already occupied");

        LandingPadRegion created = new LandingPadRegion(pos, y, "");
        chunk.setAttached(PERSISTENT, created);

        Network.syncTracked(Network.Action.ADD, this.world, pos);
        return created;
    }

    public LandingPadRegion claim(class_2338 pos) {
        return this.claim(new class_1923(pos), world.method_8497(class_4076.method_18675(pos.method_10263()), class_4076.method_18675(pos.method_10260()))
                .method_12005(class_2902.class_2903.field_13203, pos.method_10263() & 15, pos.method_10260() & 15));
    }

    private @Nullable LandingPadRegion release(class_1923 pos) {
        LandingPadRegion result = this.world.method_8497(pos.field_9181, pos.field_9180).removeAttached(PERSISTENT);

        Network.syncTracked(Network.Action.REMOVE, this.world, pos);
        return result;
    }

    public @Nullable LandingPadRegion releaseAt(class_2338 pos) {
        return this.release(new class_1923(pos));
    }

    public static LandingPadManager getInstance(class_3218 world) {
        return new LandingPadManager(world);
    }

    public static class Network {

        public static final class_2960 SYNC = AITMod.id("landingpad_sync");
        public static final class_2960 REQUEST = AITMod.id("landingpad_request");

        public static void syncForPlayer(Action action, class_3222 player) {
            class_3218 world = player.method_51469();
            class_1923 pos = player.method_31476();

            class_2540 buf = PacketByteBufs.create();
            buf.method_10817(action);

            if (action != Action.CLEAR)
                buf.method_36130(pos);

            if (action == Action.ADD) {
                LandingPadManager manager = LandingPadManager.getInstance(world);
                LandingPadRegion region = manager.getRegion(pos);

                if (region == null)
                    return;

                NetworkUtil.send(player, buf, SYNC, LandingPadRegion.CODEC, region);
                return;
            }

            NetworkUtil.send(player, SYNC, buf);
        }

        public static void syncTracked(Action action, class_3218 world, class_1923 pos) {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10817(action);

            if (action != Action.CLEAR)
                buf.method_36130(pos);

            if (action == Action.ADD) {
                LandingPadManager manager = LandingPadManager.getInstance(world);
                LandingPadRegion region = manager.getRegion(pos);

                if (region == null)
                    return;

                for (class_3222 player : PlayerLookup.tracking(world, pos)) {
                    NetworkUtil.send(player, buf, SYNC, LandingPadRegion.CODEC, region);
                }

                return;
            }

            for (class_3222 player : PlayerLookup.tracking(world, pos)) {
                NetworkUtil.send(player, SYNC, buf);
            }
        }

        static {
            ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
                syncForPlayer(Action.ADD, handler.method_32311());
            });

            ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> {
                syncForPlayer(Action.CLEAR, player);
                syncForPlayer(Action.ADD, player);
            });

            ServerPlayNetworking.registerGlobalReceiver(LandingPadManager.Network.REQUEST, (server, player, handler, buf, responseSender) -> {
                syncForPlayer(Action.ADD, player);
            });
        }

        public enum Action {
            ADD,
            REMOVE,
            CLEAR
        }
    }
}
