package dev.amble.ait.core.world;

import dev.drtheo.queue.api.util.structure.QueuedStructureTemplate;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_3499;
import net.minecraft.class_5819;
import dev.amble.ait.api.tardis.link.v2.block.InteriorLinkableBlockEntity;
import dev.amble.ait.core.tardis.ServerTardis;

public class QueuedTardisStructureTemplate extends QueuedStructureTemplate {

    private final ServerTardis tardis;

    public QueuedTardisStructureTemplate(class_3499 template, ServerTardis tardis) {
        super(template);
        this.tardis = tardis;
    }

    @Override
    protected void readNbt(class_2586 blockEntity, class_2487 nbt, class_5819 random) {
        if (blockEntity instanceof InteriorLinkableBlockEntity linkable) {
            /*
             It's faster to remove the tardis from the nbt
             than make it do id -> string -> map -> string -> id
             */
            nbt.method_10551("tardis");
            linkable.link(tardis);
        }

        super.readNbt(blockEntity, nbt, random);
    }
}
