package dev.amble.ait.core.world;

import com.mojang.serialization.Codec;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2839;
import net.minecraft.class_2919;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.events.ServerChunkEvents;

@SuppressWarnings("UnstableApiUsage")
public record RiftChunkManager(class_3218 world) {

    private static final AttachmentType<Double> ARTRON = AttachmentRegistry.createPersistent(
            AITMod.id("artron"), Codec.DOUBLE
    );

    private static final AttachmentType<Double> MAX_ARTRON = AttachmentRegistry.createPersistent(
            AITMod.id("max_artron"), Codec.DOUBLE
    );

    public static void init() {
        ServerChunkEvents.TICK.register((world, chunk) -> {
            if (world.method_8503().method_3780() % 20 != 0)
                return;

            RiftChunkManager manager = RiftChunkManager.getInstance(world);
            class_1923 pos = chunk.method_12004();

            if (!manager.isRiftChunk(pos))
                return;

            if (manager.getMaxArtron(pos) < manager.getArtron(pos))
                manager.addFuel(chunk.method_12004(), 1);
        });
    }

    public static RiftChunkManager getInstance(class_3218 world) {
        return new RiftChunkManager(world);
    }

    public double getArtron(class_1923 pos) {
        if (!this.isRiftChunk(pos))
            return 0;

        class_2791 shouldBeProtoChunk = this.world.method_14178().method_12121(pos.field_9181, pos.field_9180, class_2806.field_16423, true);

        if (!(shouldBeProtoChunk instanceof class_2839 protoChunk))
            return 0;

        return protoChunk.getAttachedOrCreate(ARTRON, () -> (double) world.method_8409().method_39332(100, 800));
    }

    public double getMaxArtron(class_1923 pos) {
        if (!this.isRiftChunk(pos))
            return 0;

        class_2791 shouldBeProtoChunk = this.world.method_14178().method_12121(pos.field_9181, pos.field_9180, class_2806.field_16423, true);

        if (!(shouldBeProtoChunk instanceof class_2839 protoChunk))
            return 0;

        return protoChunk.getAttachedOrCreate(ARTRON, () -> (double) world.method_8409().method_39332(300, 1000));
    }

    public double removeFuel(class_1923 pos, double amount) {
        if (!this.isRiftChunk(pos))
            return 0;

        double artron = this.getArtron(pos);
        artron -= artron < amount ? 0 : amount;

        class_2791 shouldBeProtoChunk = this.world.method_14178().method_12121(pos.field_9181, pos.field_9180, class_2806.field_16423, true);
        if (shouldBeProtoChunk instanceof class_2839 protoChunk) {
            protoChunk.setAttached(ARTRON, artron);
        }
        return artron - amount;
    }

    public void addFuel(class_1923 pos, double amount) {
        if (!this.isRiftChunk(pos))
            return;

        RiftChunkManager.addFuel(this.world, pos, amount);
    }

    public void setCurrentFuel(class_1923 pos, double amount) {
        class_2791 shouldBeProtoChunk = this.world.method_14178().method_12121(pos.field_9181, pos.field_9180, class_2806.field_16423, true);

        if (shouldBeProtoChunk instanceof class_2839 protoChunk) {
            protoChunk.modifyAttached(ARTRON, d -> amount);
        }
    }

    public boolean isRiftChunk(class_1923 chunkPos) {
        return RiftChunkManager.isRiftChunk(this.world, chunkPos);
    }

    public boolean isRiftChunk(class_2338 pos) {
        return RiftChunkManager.isRiftChunk(world, pos);
    }

    public static boolean isRiftChunk(CachedDirectedGlobalPos cached) {
        return isRiftChunk(cached.getWorld(), cached.getPos());
    }

    public static boolean isRiftChunk(class_5281 world, class_2338 pos) {
        return isRiftChunk(world, new class_1923(pos));
    }

    public static boolean isRiftChunk(class_5281 world, class_1923 pos) {
        return class_2919.method_12662(pos.field_9181, pos.field_9180,
                world.method_8412(), 987234910L
        ).method_43048(8) == 0;
    }

    private static void addFuel(class_5425 world, class_1923 pos, double amount) {
        class_2791 shouldBeProtoChunk = world.method_8398().method_12121(pos.field_9181, pos.field_9180, class_2806.field_16423, true);

        if (shouldBeProtoChunk instanceof class_2839 protoChunk) {
            protoChunk.modifyAttached(ARTRON, d -> d + amount);
        }
    }

    public static double getFuel(class_3218 world, class_1923 pos) {
        if (!isRiftChunk(world, pos))
            return 0;

        class_2791 shouldBeProtoChunk = world.method_14178().method_12121(pos.field_9181, pos.field_9180, class_2806.field_16423, true);

        if (!(shouldBeProtoChunk instanceof class_2839 protoChunk))
            return 0;

        return protoChunk.getAttachedOrCreate(ARTRON, () -> (double) world.method_8409().method_39332(100, 800));
    }

    public static double getMaxFuel(class_3218 world, class_1923 pos) {
        if (!isRiftChunk(world, pos))
            return 0;

        class_2791 shouldBeProtoChunk = world.method_14178().method_12121(pos.field_9181, pos.field_9180, class_2806.field_16423, true);

        if (!(shouldBeProtoChunk instanceof class_2839 protoChunk))
            return 0;

        return protoChunk.getAttachedOrCreate(MAX_ARTRON, () -> (double) world.method_8409().method_39332(300, 1000));
    }
}
