package dev.amble.ait.core.world;

import dev.amble.ait.AITMod;
import dev.amble.ait.compat.DependencyChecker;
import dev.amble.ait.core.AITDimensions;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.lib.util.ServerLifecycleHooks;
import dev.drtheo.multidim.MultiDim;
import dev.drtheo.multidim.MultiDimMod;
import dev.drtheo.multidim.api.MultiDimServerWorld;
import dev.drtheo.multidim.api.WorldBlueprint;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3949;
import net.minecraft.class_5268;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8565;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.api.DimensionAPI;
import qouteall.q_misc_util.dimension.DimensionIdManagement;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;

public class TardisServerWorld extends MultiDimServerWorld {

    public static final String NAMESPACE = AITMod.MOD_ID + "-tardis";

    private ServerTardis tardis;
    private class_6880<class_1959> cachedBiome;

    public TardisServerWorld(WorldBlueprint blueprint, MinecraftServer server, Executor workerExecutor, class_32.class_5143 session, class_5268 properties, class_5321<class_1937> worldKey, class_5363 dimensionOptions, class_3949 worldGenerationProgressListener, List<class_5304> spawners, @Nullable class_8565 randomSequencesState, boolean created) {
        super(blueprint, server, workerExecutor, session, properties, worldKey, dimensionOptions, worldGenerationProgressListener, spawners, randomSequencesState, created);
        this.method_8424(false, false);
    }

    @Override
    public void method_18765(BooleanSupplier shouldKeepTicking) {
        if (this.shouldTick()) {
            super.method_18765(shouldKeepTicking);
        }
    }

    public boolean shouldTick() {
        return this.tardis != null && (
                !MultiDim.get(this.method_8503()).isWorldUnloaded(this)
                || this.tardis.interiorChanging().queued().get()
                || this.tardis.getDesktop().isChanging()
        );
    }

    @Override
    public String toString() {
        return "Tardis" + super.toString();
    }

    @Override
    public class_6880<class_1959> method_23753(class_2338 pos) {
        if (this.cachedBiome != null)
            return cachedBiome;

        this.cachedBiome = super.method_23753(pos);
        return cachedBiome;
    }

    public void setTardis(ServerTardis tardis) {
        this.tardis = tardis;
    }

    public ServerTardis getTardis() {
        return tardis;
    }

    public static TardisServerWorld create(ServerTardis tardis) {
        AITMod.LOGGER.info("Creating a dimension for TARDIS {}", tardis.getUuid());
        TardisServerWorld created = (TardisServerWorld) MultiDim.get(ServerLifecycleHooks.get())
                .add(AITDimensions.TARDIS_WORLD_BLUEPRINT, idForTardis(tardis));

        created.setTardis(tardis);
        return created;
    }

    public static TardisServerWorld getOrLoad(ServerTardis tardis) {
        MinecraftServer server = ServerLifecycleHooks.get();
        class_5321<class_1937> key = keyForTardis(tardis);

        TardisServerWorld result = (TardisServerWorld) server.method_3847(key);

        if (result != null) {
            result.setTardis(tardis);
            return result;
        }

        return load(server, tardis);
    }

    public static TardisServerWorld load(MinecraftServer server, ServerTardis tardis) {
        MultiDim multidim = MultiDim.get(server);

        class_5321<class_1937> key = keyForTardis(tardis);
        TardisServerWorld result = (TardisServerWorld) multidim.load(AITDimensions.TARDIS_WORLD_BLUEPRINT, key);

        if (result == null) {
            MultiDimMod.LOGGER.info("Failed to load the sub-world, creating a new one instead");
            result = create(tardis);
        } else {
            result.setTardis(tardis);
        }

        return result;
    }

    public static class_5321<class_1937> keyForTardis(ServerTardis tardis) {
        return class_5321.method_29179(class_7924.field_41223, idForTardis(tardis));
    }

    private static class_2960 idForTardis(ServerTardis tardis) {
        return new class_2960(NAMESPACE, tardis.getUuid().toString());
    }

    public static boolean isTardisDimension(class_5321<class_1937> key) {
        return NAMESPACE.equals(key.method_29177().method_12836());
    }

    public static boolean isTardisDimension(class_1937 world) {
        return world.method_8608() ? isTardisDimension((class_638) world) : isTardisDimension((class_3218) world);
    }

    public static boolean isTardisDimension(class_3218 world) {
        return world instanceof TardisServerWorld;
    }

    @Nullable public static UUID getTardisId(@Nullable class_1937 world) {
        if (world == null || !isTardisDimension(world))
            return null;

        return getTardisId(world.method_27983());
    }

    public static UUID getTardisId(class_5321<class_1937> key) {
        return UUID.fromString(key.method_29177().method_12832());
    }

    @Environment(EnvType.CLIENT)
    public static boolean isTardisDimension(class_638 world) {
        return isTardisDimension(world.method_27983());
    }
}
