package dev.amble.ait.data;

import java.lang.reflect.Type;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import com.google.gson.*;

public class Corners {
    @Exclude
    private final class_238 box;

    private final class_2338 first;
    private final class_2338 second;

    public Corners(class_2338 first, class_2338 second) {
        this.box = new class_238(first, second);

        this.first = first;
        this.second = second;
    }

    public class_238 getBox() {
        return box;
    }

    public class_2338 getFirst() {
        return first;
    }

    public class_2338 getSecond() {
        return second;
    }

    @Override
    public String toString() {
        return "Corners{" + "box=" + box + ", first=" + first + ", second=" + second + '}';
    }

    public static Object serializer() {
        return new Serializer();
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();

        nbt.method_10566("first", class_2512.method_10692(first));
        nbt.method_10566("second", class_2512.method_10692(second));

        return nbt;
    }

    public static Corners fromNbt(class_2487 nbt) {
        return new Corners(class_2512.method_10691(nbt.method_10562("first")), class_2512.method_10691(nbt.method_10562("second")));
    }

    private static class Serializer implements JsonDeserializer<Corners> {

        @Override
        public Corners deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
                throws JsonParseException {
            JsonObject corners = json.getAsJsonObject();

            return new Corners(context.deserialize(corners.get("first"), class_2338.class),
                    context.deserialize(corners.get("second"), class_2338.class));
        }
    }
}
