package dev.amble.ait.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import com.google.common.collect.Maps;

public class ShapeMap {

    private final Map<class_2350, class_265> map;

    private ShapeMap(Map<class_2350, class_265> map) {
        this.map = Maps.newEnumMap(map);
    }

    public class_265 get(class_2350 direction) {
        return this.map.get(direction);
    }

    public static class Builder {

        private final Map<class_2350, class_265> map;

        private Builder(Map<class_2350, class_265> map) {
            this.map = map;
        }

        public Builder() {
            this(new HashMap<>(6));
        }

        public Builder add(class_2350 direction, class_265 shape) {
            this.map.put(direction, shape);
            return this;
        }

        public Builder union(ShapeMap other) {
            for (class_2350 direction : class_2350.values()) {
                class_265 own = this.map.get(direction);
                class_265 another = other.get(direction);

                this.add(direction, class_259.method_1084(own, another));
            }

            return this;
        }

        public ShapeMap build() {
            return new ShapeMap(this.map);
        }
    }
}
