package dev.amble.ait.data.datapack;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.joml.Vector3f;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.tardis.control.ControlTypes;
import dev.amble.ait.data.codec.MoreCodec;
import dev.amble.ait.data.schema.console.ConsoleTypeSchema;
import dev.amble.ait.data.schema.console.ConsoleVariantSchema;
import dev.amble.ait.registry.impl.console.ConsoleRegistry;

// Example usage
/*
{
  "id": "ait:white_alnico",
  "parent": "ait:console/alnico",
  "texture": "ait:textures/console/alnico.png",
  "emission": "ait:textures/console/alnico_emission.png"
}
 */
public class DatapackConsole extends ConsoleVariantSchema implements TravelAnimationMap.Holder {
    public static final class_2960 EMPTY = AITMod.id("intentionally_empty");

    protected final class_2960 texture;
    protected final class_2960 emission;
    protected final class_2960 id;
    protected final List<Float> sonicRotation;
    protected final Vector3f sonicTranslation;
    protected final List<Float> handlesRotation;
    protected final Vector3f handlesTranslation;
    protected final class_2960 model;
    protected final class_243 scale;
    protected final class_243 offset;
    public static final Codec<DatapackConsole> CODEC = RecordCodecBuilder.create(instance -> instance
            .group(class_2960.field_25139.fieldOf("id").forGetter(ConsoleVariantSchema::id),
                    class_2960.field_25139.optionalFieldOf("parent").forGetter(c -> Optional.ofNullable(c.parentId())),
                    class_2960.field_25139.fieldOf("texture").forGetter(DatapackConsole::texture),
                    class_2960.field_25139.optionalFieldOf("emission", EMPTY).forGetter(DatapackConsole::emission),
                    Codec.list(Codec.FLOAT).optionalFieldOf("sonic_rotation", List.of())
                            .forGetter(DatapackConsole::sonicRotation),
                    MoreCodec.VECTOR3F.optionalFieldOf("sonic_translation", new Vector3f()).forGetter(DatapackConsole::sonicTranslation),
                    Codec.list(Codec.FLOAT).optionalFieldOf("handles_rotation", List.of())
                            .forGetter(DatapackConsole::handlesRotation),
                    MoreCodec.VECTOR3F.optionalFieldOf("handles_translation", new Vector3f()).forGetter(DatapackConsole::handlesTranslation),
                    class_2960.field_25139.optionalFieldOf("model").forGetter(DatapackConsole::model),
                    class_243.field_38277.optionalFieldOf("scale", new class_243(1, 1, 1)).forGetter(DatapackConsole::getScale),
                    class_243.field_38277.optionalFieldOf("offset", new class_243(0, 0, 0)).forGetter(DatapackConsole::getOffset),
                    TravelAnimationMap.CODEC.optionalFieldOf("animations", new TravelAnimationMap())
                            .forGetter(DatapackConsole::getAnimations),
                    SimpleType.CODEC.optionalFieldOf("type").forGetter(DatapackConsole::getCustomType),
                    Codec.BOOL.optionalFieldOf("isDatapack", true).forGetter(DatapackConsole::wasDatapack))
            .apply(instance, DatapackConsole::new));
    protected boolean initiallyDatapack;
    protected final TravelAnimationMap animations;

    public DatapackConsole(class_2960 id,
                           Optional<class_2960> category,
                           class_2960 texture,
                           class_2960 emission,
                           List<Float> sonicRot,
                           Vector3f sonicTranslation,
                           List<Float> handlesRot,
                           Vector3f handlesTranslation,
                           Optional<class_2960> model,
                           class_243 scale,
                           class_243 offset,
                           TravelAnimationMap animations,
                           Optional<SimpleType> type,
                           boolean isDatapack) {
        super(resolveParentId(category, type), id);
        this.id = id;
        this.texture = texture;
        this.emission = emission;
        this.initiallyDatapack = isDatapack;
        this.sonicRotation = sonicRot;
        this.sonicTranslation = sonicTranslation;
        this.handlesRotation = handlesRot;
        this.handlesTranslation = handlesTranslation;
        this.model = model.orElse(null);
        this.scale = scale;
        this.offset = offset;
        this.animations = animations != null ? animations : new TravelAnimationMap();
    }

    private static class_2960 resolveParentId(Optional<class_2960> parent, Optional<SimpleType> type) {
        if (parent.isPresent()) {
            return parent.get();
        } else if (type.isPresent()) {
            type.get().register();
            return type.get().id();
        } else {
            throw new IllegalArgumentException("DatapackConsole must have a parent or a type defined");
        }
    }

    public boolean wasDatapack() {
        return this.initiallyDatapack;
    }

    public class_2960 texture() {
        return this.texture;
    }

    public class_2960 emission() {
        return this.emission;
    }

    public class_2960 id() {
        return this.id;
    }

    public List<Float> sonicRotation() {
        return this.sonicRotation;
    }
    public Vector3f sonicTranslation() {
        return this.sonicTranslation;
    }

    public List<Float> handlesRotation() {
        return this.handlesRotation;
    }
    public Vector3f handlesTranslation() {
        return this.handlesTranslation;
    }

    public Optional<class_2960> model() {
        return Optional.ofNullable(model);
    }

    public class_243 getScale() {
        return scale;
    }

    public class_243 getOffset() {
        return offset;
    }

    @Override
    public TravelAnimationMap getAnimations() {
        return animations;
    }

    public Optional<SimpleType> getCustomType() {
        if (this.parent() instanceof SimpleType simpleType) {
            return Optional.of(simpleType);
        }
        return Optional.empty();
    }

    public static DatapackConsole fromInputStream(InputStream stream) {
        return fromJson(JsonParser.parseReader(new InputStreamReader(stream)).getAsJsonObject());
    }

    public static DatapackConsole fromJson(JsonObject json) {
        AtomicReference<DatapackConsole> created = new AtomicReference<>();

        CODEC.decode(JsonOps.INSTANCE, json).get().ifLeft(var -> created.set(var.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack console variant: {}", err);
        });

        return created.get();
    }

    public static class SimpleType extends ConsoleTypeSchema {
        public static final Codec<SimpleType> CODEC = RecordCodecBuilder.create(instance -> instance
                .group(class_2960.field_25139.fieldOf("id").forGetter(SimpleType::id),
                        Codec.STRING.fieldOf("name").forGetter(SimpleType::name),
                        ControlTypes.CODEC.listOf().fieldOf("controls").forGetter(c -> c.controls))
                .apply(instance, SimpleType::new));

        private final List<ControlTypes> controls;

        protected SimpleType(class_2960 id, String name, List<ControlTypes> controls) {
            super(id, name);

            this.controls = controls;
        }

        @Override
        public ControlTypes[] getControlTypes() {
            return controls.toArray(new ControlTypes[0]);
        }

        public void register() {
            ConsoleRegistry.getInstance().register(this);
        }
    }
}
