package dev.amble.ait.data.datapack;

import static dev.amble.ait.data.datapack.DatapackConsole.EMPTY;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.lib.client.bedrock.BedrockAnimationReference;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.util.PortalOffsets;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.datapack.exterior.BiomeOverrides;
import dev.amble.ait.data.schema.door.AnimatedDoor;
import dev.amble.ait.data.schema.door.DoorSchema;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.registry.impl.door.DoorRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings("OptionalUsedAsFieldOrParameterType")
public class DatapackExterior extends ExteriorVariantSchema implements AnimatedDoor, TravelAnimationMap.Holder {

    public static final class_2960 DEFAULT_TEXTURE = new class_2960(AITMod.MOD_ID,
            "textures/gui/tardis/desktop/missing_preview.png");

    protected final class_2960 parent;
    protected final class_2960 texture;
    protected final class_2960 emission;
    protected final BiomeOverrides overrides;
    protected final class_243 seatTranslations;
    protected final boolean initiallyDatapack;
    protected final boolean hasTransparentDoors;
    protected final class_2960 model;
    protected final class_2960 doorId;
    protected final PortalOffsets portalOffsets;
    protected final BedrockAnimationReference leftAnimation;
    protected final BedrockAnimationReference rightAnimation;
    public static final Codec<DatapackExterior> CODEC = RecordCodecBuilder.create(instance -> instance
            .group(class_2960.field_25139.fieldOf("id").forGetter(ExteriorVariantSchema::id),
                    class_2960.field_25139.fieldOf("category").forGetter(ExteriorVariantSchema::categoryId),
                    class_2960.field_25139.fieldOf("parent").forGetter(DatapackExterior::getParentId),
                    class_2960.field_25139.fieldOf("texture").forGetter(DatapackExterior::texture),
                    class_2960.field_25139.optionalFieldOf("emission", EMPTY).forGetter(DatapackExterior::emission),
                    Loyalty.CODEC.optionalFieldOf("loyalty").forGetter(DatapackExterior::requirement),
                    BiomeOverrides.CODEC.fieldOf("overrides").orElse(BiomeOverrides.EMPTY)
                            .forGetter(DatapackExterior::overrides),
                    class_243.field_38277.optionalFieldOf("seat_translations", new class_243(0.5, 1, 0.5)).forGetter(DatapackExterior::seatTranslations),
                    Codec.BOOL.optionalFieldOf("has_transparent_doors", false).forGetter(DatapackExterior::hasTransparentDoors),
                    class_2960.field_25139.optionalFieldOf("model").forGetter(DatapackExterior::model),
                    class_2960.field_25139.optionalFieldOf("door").forGetter(DatapackExterior::getDoorId),
                    PortalOffsets.CODEC.optionalFieldOf("portal_info").forGetter(DatapackExterior::portalOffsets),
                    BedrockAnimationReference.CODEC.optionalFieldOf("left_animation").forGetter(DatapackExterior::getLeftAnimation),
                    BedrockAnimationReference.CODEC.optionalFieldOf("right_animation").forGetter(DatapackExterior::getRightAnimation),
                    class_243.field_38277.optionalFieldOf("scale", new class_243(1, 1, 1)).forGetter(DatapackExterior::getScale),
                    TravelAnimationMap.CODEC.optionalFieldOf("animations", new TravelAnimationMap())
                            .forGetter(DatapackExterior::getAnimations)
            ).apply(instance, DatapackExterior::new)
        );
    protected final class_243 scale;
    protected final TravelAnimationMap animations;

    public DatapackExterior(class_2960 id, class_2960 category, class_2960 parent, class_2960 texture,
                            class_2960 emission, Optional<Loyalty> loyalty, BiomeOverrides overrides, class_243 seatTranslations, boolean hasTransparentDoors, Optional<class_2960> model, Optional<class_2960> door, Optional<PortalOffsets> offsets, Optional<BedrockAnimationReference> leftAnimation, Optional<BedrockAnimationReference> rightAnimation, class_243 scale, TravelAnimationMap animations) {
        super(category, id, loyalty);
        this.parent = parent;
        this.texture = texture;
        this.emission = emission;
        this.seatTranslations = seatTranslations;
        this.hasTransparentDoors = hasTransparentDoors;
        this.initiallyDatapack = true;
        this.overrides = overrides;
        this.model = model.orElse(null);
        this.doorId = door.orElse(null);
        this.portalOffsets = offsets.orElse(null);
        this.leftAnimation = leftAnimation.orElse(null);
        this.rightAnimation = rightAnimation.orElse(null);
        this.scale = scale;
        this.animations = animations;
    }

    public static DatapackExterior fromInputStream(InputStream stream) {
        return fromJson(JsonParser.parseReader(new InputStreamReader(stream)).getAsJsonObject());
    }

    public static DatapackExterior fromJson(JsonObject json) {
        AtomicReference<DatapackExterior> created = new AtomicReference<>();

        CODEC.decode(JsonOps.INSTANCE, json).get().ifLeft(var -> created.set(var.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack exterior variant: {}", err);
        });

        return created.get();
    }

    public ExteriorVariantSchema getParent() {
        return ExteriorVariantRegistry.getInstance().get(this.getParentId());
    }

    public class_2960 getParentId() {
        return this.parent;
    }

    private Optional<class_2960> getDoorId() {
        return Optional.ofNullable(this.door().id());
    }

    @Override
    public DoorSchema door() {
        if (doorId == null) {
            return this.getParent().door();
        }

        return DoorRegistry.getInstance().getOrElse(doorId, this.getParent().door());
    }

    public BiomeOverrides overrides() {
        return overrides;
    }

    @Override
    public class_243 seatTranslations() {
        return seatTranslations;
    }

    public boolean hasTransparentDoors() {
        return hasTransparentDoors;
    }

    @Override
    public class_265 bounding(class_2350 dir) {
        return this.getParent().bounding(dir);
    }

    @Override
    public boolean hasPortals() {
        if (this.getPortalOffsets() != null) {
            return this.getPortalOffsets().isEnabled();
        }

        return this.getParent().hasPortals();
    }

    @Override
    public @Nullable class_243 getPortalPosition() {
        if (this.getPortalOffsets() != null) {
            return this.getPortalOffsets().apply(class_243.field_1353, (byte) 0);
        }

        return this.getParent().getPortalPosition();
    }

    @Override
    public double portalWidth() {
        if (this.getPortalOffsets() != null) {
            return this.getPortalOffsets().getWidth();
        }

        return this.getParent().portalWidth();
    }

    @Override
    public double portalHeight() {
        if (this.getPortalOffsets() != null) {
            return this.getPortalOffsets().getHeight();
        }

        return this.getParent().portalHeight();
    }

    public boolean wasDatapack() {
        return this.initiallyDatapack;
    }

    public class_2960 texture() {
        return this.texture;
    }

    public class_2960 emission() {
        return this.emission;
    }

    /**
     * A possible identifier for a bedrock model in the BedrockModelRegistry.
     */
    public Optional<class_2960> model() {
        return Optional.ofNullable(this.model);
    }

    public Optional<PortalOffsets> portalOffsets() {
        return Optional.ofNullable(this.portalOffsets);
    }

    public PortalOffsets getPortalOffsets() {
        return this.portalOffsets;
    }

    @Override
    public Optional<BedrockAnimationReference> getLeftAnimation() {
        return Optional.ofNullable(this.leftAnimation);
    }

    @Override
    public Optional<BedrockAnimationReference> getRightAnimation() {
        return Optional.ofNullable(this.rightAnimation);
    }

    @Override
    public class_243 getScale() {
        return scale;
    }

    @Override
    public TravelAnimationMap getAnimations() {
        return animations;
    }
}
