package dev.amble.ait.data.datapack.exterior;

import java.util.Map;
import java.util.function.Function;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3542;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.data.enummap.EnumMap;

public record BiomeOverrides(EnumMap.Compliant<BiomeHandler.BiomeType, class_2960> lookup) {

    public static BiomeOverrides EMPTY = new BiomeOverrides(createMap());

    private static EnumMap.Compliant<BiomeHandler.BiomeType, class_2960> createMap() {
        return new EnumMap.Compliant<>(() -> BiomeHandler.BiomeType.VALUES, class_2960[]::new);
    }

    private BiomeOverrides(Map<BiomeHandler.BiomeType, class_2960> map) {
        this(createMap());
        this.lookup.putAll(map);
    }

    public class_2960 get(BiomeHandler.BiomeType type) {
        return this.lookup.get(type);
    }

    @Environment(EnvType.CLIENT)
    public void validate() {
        class_3300 manager = class_310.method_1551().method_1478();

        this.lookup.map(id -> {
            if (id == null)
                return null;

            return manager.method_14486(id).isPresent() ? id : null;
        });
    }

    public static BiomeOverrides of(Function<BiomeHandler.BiomeType, class_2960> func) {
        EnumMap.Compliant<BiomeHandler.BiomeType, class_2960> map = createMap();

        for (BiomeHandler.BiomeType type : BiomeHandler.BiomeType.VALUES) {
            map.put(type, func.apply(type));
        }

        return new BiomeOverrides(map);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BiomeOverrides overrides) {
        return new Builder(overrides);
    }

    public static final MapCodec<BiomeOverrides> CODEC = RecordCodecBuilder.mapCodec(instance ->
            instance.group(
                    Codec.simpleMap(
                            BiomeHandler.BiomeType.CODEC, class_2960.field_25139,
                            class_3542.method_28142(BiomeHandler.BiomeType.VALUES)
                    ).forGetter(overrides -> overrides.lookup)
            ).apply(instance, BiomeOverrides::new));

    public static class Builder {

        private final EnumMap.Compliant<BiomeHandler.BiomeType, class_2960> map = createMap();

        private Builder() { }

        private Builder(BiomeOverrides overrides) {
            for (BiomeHandler.BiomeType type : BiomeHandler.BiomeType.VALUES) {
                this.with(type, overrides.lookup().get(type));
            }
        }

        public Builder with(BiomeHandler.BiomeType type, class_2960 id) {
            map.put(type, id);
            return this;
        }

        public Builder with(Function<BiomeHandler.BiomeType, class_2960> func, BiomeHandler.BiomeType... types) {
            for (BiomeHandler.BiomeType type : types) {
                this.with(type, func.apply(type));
            }

            return this;
        }

        public BiomeOverrides build() {
            return new BiomeOverrides(map);
        }
    }
}
