package dev.amble.ait.data.gson;

import java.lang.reflect.Type;
import net.minecraft.class_2338;
import com.google.gson.*;

public class BlockPosSerializer implements JsonDeserializer<class_2338>, JsonSerializer<class_2338> {

    @Override
    public class_2338 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
            throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();

        int x = obj.get("x").getAsInt();
        int y = obj.get("y").getAsInt();
        int z = obj.get("z").getAsInt();

        return new class_2338(x, y, z);
    }

    @Override
    public JsonElement serialize(class_2338 src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();

        result.addProperty("x", src.method_10263());
        result.addProperty("y", src.method_10264());
        result.addProperty("z", src.method_10260());

        return result;
    }
}
