package dev.amble.ait.data.gson;

import java.lang.reflect.Type;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import com.google.gson.*;

public class GlobalPosSerializer implements JsonDeserializer<class_4208>, JsonSerializer<class_4208> {

    @Override
    public class_4208 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
            throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();

        class_5321<class_1937> dimension = context.deserialize(obj.get("dimension"), class_5321.class);

        int x = obj.get("x").getAsInt();
        int y = obj.get("y").getAsInt();
        int z = obj.get("z").getAsInt();

        return class_4208.method_19443(dimension, new class_2338(x, y, z));
    }

    @Override
    public JsonElement serialize(class_4208 src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();

        result.add("dimension", context.serialize(src.method_19442().method_29177()));
        result.addProperty("x", src.method_19446().method_10263());
        result.addProperty("y", src.method_19446().method_10264());
        result.addProperty("z", src.method_19446().method_10260());

        return result;
    }
}
