package dev.amble.ait.data.gson;

import java.lang.reflect.Type;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_5626;
import com.google.gson.*;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.AITMod;

public class NbtSerializer implements JsonSerializer<class_2487>, JsonDeserializer<class_2487> {
    @Override
    public class_2487 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
            throws JsonParseException {
        try {
            return class_2522.method_10718(json.getAsString());
        } catch (CommandSyntaxException e) {
            AITMod.LOGGER.error("Invalid NBT string: {}", json.getAsString());
            return new class_2487();
        }
    }

    @Override
    public JsonElement serialize(class_2487 src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize(new class_5626().method_32288(src));
    }
}
