package dev.amble.ait.data.hum;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_5699;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.ait.AITMod;

public class DatapackHum extends Hum {
    public static final Codec<Hum> CODEC = RecordCodecBuilder.create(instance -> instance
            .group(class_2960.field_25139.fieldOf("id").forGetter(Hum::id), class_3414.field_41698.fieldOf("sound").forGetter(Hum::sound),
                    class_5699.field_41759.optionalFieldOf("name").forGetter(Hum::nameOptional))
            .apply(instance, DatapackHum::new));

    protected DatapackHum(class_2960 id, class_3414 sound, Optional<String> name) {
        super(name.orElse(id.method_12832()), id, sound);
    }

    public static Hum fromInputStream(InputStream stream) {
        return fromJson(JsonParser.parseReader(new InputStreamReader(stream)).getAsJsonObject());
    }

    public static Hum fromJson(JsonObject json) {
        AtomicReference<Hum> created = new AtomicReference<>();

        CODEC.decode(JsonOps.INSTANCE, json).get().ifLeft(hum -> created.set(hum.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack hum: {}", err);
        });

        return created.get();
    }
}
