package dev.amble.ait.data.schema.console;

import java.lang.reflect.Type;

import com.google.gson.*;
import dev.amble.lib.api.Identifiable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import org.joml.Vector3f;
import dev.amble.ait.client.models.consoles.ConsoleModel;
import dev.amble.ait.data.schema.console.variant.hartnell.HartnellVariant;
import dev.amble.ait.registry.impl.console.variant.ClientConsoleVariantRegistry;
import dev.amble.ait.registry.impl.console.variant.ConsoleVariantRegistry;

@Environment(EnvType.CLIENT)
public abstract class ClientConsoleVariantSchema implements Identifiable {

    private final class_2960 parent;
    private final class_2960 id;

    protected ClientConsoleVariantSchema(class_2960 parent, class_2960 id) {
        this.parent = parent;
        this.id = id;
    }

    protected ClientConsoleVariantSchema(class_2960 parent) {
        this.id = parent;
        this.parent = parent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;

        return o instanceof ClientConsoleVariantSchema other && this.id.equals(other.id);
    }

    public ConsoleVariantSchema parent() {
        return ConsoleVariantRegistry.getInstance().get(this.parent);
    }

    public class_2960 id() {
        return id;
    }

    public abstract class_2960 texture();

    public abstract class_2960 emission();

    @Environment(EnvType.CLIENT)
    public abstract ConsoleModel model();

    public static Object serializer() {
        return new Serializer();
    }

    public Vector3f sonicItemTranslations() {
        return ConsoleVariantSchema.DEFAULT_SONIC_POS;
    }

    public float[] sonicItemRotations() {
        return ConsoleVariantSchema.DEFAULT_SONIC_ROTATION;
    }

    public Vector3f handlesTranslations() {
        return ConsoleVariantSchema.DEFAULT_HANDLES_POS;
    }

    public float[] handlesRotations() {
        return ConsoleVariantSchema.DEFAULT_HANDLES_ROTATION;
    }

    private static class Serializer
            implements
                JsonSerializer<ClientConsoleVariantSchema>,
                JsonDeserializer<ClientConsoleVariantSchema> {

        @Override
        public ClientConsoleVariantSchema deserialize(JsonElement json, Type typeOfT,
                JsonDeserializationContext context) throws JsonParseException {
            class_2960 id;

            try {
                id = new class_2960(json.getAsJsonPrimitive().getAsString());
            } catch (class_151 e) {
                id = HartnellVariant.REFERENCE;
            }

            return ClientConsoleVariantRegistry.getInstance().get(id);
        }

        @Override
        public JsonElement serialize(ClientConsoleVariantSchema src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.id().toString());
        }
    }
}
