package dev.amble.ait.data.schema.console;

import java.lang.reflect.Type;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import com.google.gson.*;
import dev.amble.lib.api.Identifiable;
import dev.amble.ait.api.Nameable;
import dev.amble.ait.core.tardis.control.ControlTypes;
import dev.amble.ait.data.schema.exterior.category.CapsuleCategory;
import dev.amble.ait.registry.impl.console.ConsoleRegistry;
import dev.amble.ait.registry.impl.console.variant.ConsoleVariantRegistry;

public abstract class ConsoleTypeSchema implements Identifiable, Nameable {
    private final class_2960 id;
    private final String name;

    protected ConsoleTypeSchema(class_2960 id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;

        return o instanceof ConsoleTypeSchema schema && id.equals(schema.id);
    }

    @Override
    public class_2960 id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name();
    }

    // @TODO protocol abstraction with numbered letters

    public abstract ControlTypes[] getControlTypes(); // fixme this kinda sucks idk

    /**
     * The default console for this category
     */
    public ConsoleVariantSchema getDefaultVariant() {
        return ConsoleVariantRegistry.withParent(this).get(0);
    }

    public static Object serializer() {
        return new Serializer();
    }

    private static class Serializer implements JsonSerializer<ConsoleTypeSchema>, JsonDeserializer<ConsoleTypeSchema> {

        @Override
        public ConsoleTypeSchema deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
                throws JsonParseException {
            class_2960 id;

            try {
                id = new class_2960(json.getAsJsonPrimitive().getAsString());
            } catch (class_151 e) {
                id = CapsuleCategory.REFERENCE;
            }

            return ConsoleRegistry.getInstance().get(id);
        }

        @Override
        public JsonElement serialize(ConsoleTypeSchema src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.id().toString());
        }
    }
}
