package dev.amble.ait.data.schema.desktop;

import java.lang.reflect.Type;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3499;
import com.google.gson.*;
import dev.amble.lib.register.unlockable.Unlockable;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.schema.BasicSchema;
import dev.amble.ait.data.schema.desktop.textures.DesktopPreviewTexture;
import dev.amble.ait.registry.impl.DesktopRegistry;

public abstract class TardisDesktopSchema extends BasicSchema implements Unlockable {

    private final class_2960 id;

    private final DesktopPreviewTexture preview;
    private final Loyalty loyalty;

    protected TardisDesktopSchema(class_2960 id, DesktopPreviewTexture texture, Optional<Loyalty> loyalty) {
        super("desktop");
        this.id = id;

        this.preview = texture;
        this.loyalty = loyalty.orElse(null);
    }

    protected TardisDesktopSchema(class_2960 id, DesktopPreviewTexture texture, Loyalty loyalty) {
        this(id, texture, Optional.of(loyalty));
    }

    protected TardisDesktopSchema(class_2960 id, DesktopPreviewTexture texture) {
        this(id, texture, Optional.empty());
    }

    @Override
    public class_2960 id() {
        return id;
    }

    @Override
    public Optional<Loyalty> requirement() {
        return Optional.ofNullable(loyalty);
    }

    @Override
    public UnlockType unlockType() {
        return UnlockType.DESKTOP;
    }

    public DesktopPreviewTexture previewTexture() {
        return this.preview;
    }

    public Optional<class_3499> findTemplate() {
        return WorldUtil.getOverworld().method_14183()
                .method_15094(this.getStructureLocation());
    }

    private class_2960 getStructureLocation() {
        class_2960 id = this.id();

        return new class_2960(id.method_12836(), "interiors/" + id.method_12832());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;

        if (o instanceof TardisDesktopSchema that)
            return id.equals(that.id);

        return false;
    }

    public static Object serializer() {
        return new Serializer();
    }

    private static class Serializer
            implements
                JsonSerializer<TardisDesktopSchema>,
                JsonDeserializer<TardisDesktopSchema> {

        @Override
        public TardisDesktopSchema deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
                throws JsonParseException {
            return DesktopRegistry.getInstance().get(new class_2960(json.getAsJsonPrimitive().getAsString()));
        }

        @Override
        public JsonElement serialize(TardisDesktopSchema src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.id().toString());
        }
    }
}
