package dev.amble.ait.data.schema.door;

import java.util.Optional;

import dev.amble.lib.client.bedrock.BedrockAnimationReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.tardis.handler.DoorHandler;
import dev.amble.ait.data.schema.AnimatedFeature;

public interface AnimatedDoor extends AnimatedFeature {
    default Optional<BedrockAnimationReference> getLeftAnimation() {
        return Optional.empty();
    }

    default Optional<BedrockAnimationReference> getRightAnimation() {
        return Optional.empty();
    }

    default class_243 getScale() {
        return new class_243(1, 1, 1);
    }

    default class_243 getOffset() {
        return class_243.field_1353;
    }

    @Environment(EnvType.CLIENT)
    default void runAnimations(class_630 root, class_4587 matrices, float tickDelta, ClientTardis tardis) {
        DoorHandler doors = tardis.door();

        class_243 offset = this.getOffset().method_1021(-1);
        matrices.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);

        class_243 scale = this.getScale();
        matrices.method_22905((float) scale.field_1352, (float) scale.field_1351, (float) scale.field_1350);

        matrices.method_22903();
        float leftProgress = doors.getLeftRot();
        float rightProgress = doors.getRightRot();

        if (!AITModClient.CONFIG.animateDoors) {
            leftProgress = doors.isLeftOpen() ? 1 : 0;
            rightProgress = doors.isRightOpen() ? 1 : 0;
        }

        float leftDelta;
        if (leftProgress == 1 || leftProgress == 0) {
            leftDelta = 0;
        } else {
            leftDelta = tickDelta / 10F;
        }

        float rightDelta;
        if (rightProgress == 1 || rightProgress == 0) {
            rightDelta = 0;
        } else {
            rightDelta = tickDelta / 10F;
        }

        float finalRightProgress = rightProgress - 0.001F;
        float finalLeftProgress = leftProgress - 0.001F;
        this.getLeftAnimation().flatMap(BedrockAnimationReference::get).ifPresent(anim -> anim.apply(root, (int) (finalLeftProgress * anim.animationLength * 20), leftDelta));
        this.getRightAnimation().flatMap(BedrockAnimationReference::get).ifPresent(anim -> anim.apply(root, (int) (finalRightProgress * anim.animationLength * 20), rightDelta));
        matrices.method_22909();
    }
}
