package dev.amble.ait.data.schema.door;

import java.lang.reflect.Type;

import com.google.gson.*;
import dev.amble.lib.api.Identifiable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import dev.amble.ait.client.models.AnimatedModel;
import dev.amble.ait.data.schema.door.impl.CapsuleDoorVariant;
import dev.amble.ait.registry.impl.door.ClientDoorRegistry;
import dev.amble.ait.registry.impl.door.DoorRegistry;

@Environment(EnvType.CLIENT)
public abstract class ClientDoorSchema implements Identifiable {
    private final class_2960 parent;
    private final class_2960 id;

    protected ClientDoorSchema(class_2960 parent, class_2960 id) {
        this.parent = parent;
        this.id = id;
    }

    protected ClientDoorSchema(class_2960 parent) {
        this.id = parent;
        this.parent = parent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() == null)
            return false;

        ClientDoorSchema that = (ClientDoorSchema) o;

        return id.equals(that.id);
    }

    public DoorSchema parent() {
        return DoorRegistry.getInstance().get(this.parent);
    }

    @Override
    public class_2960 id() {
        return id;
    }

    // public abstract Identifier texture();
    // public abstract Identifier emission();
    public abstract AnimatedModel model();

    public static Object serializer() {
        return new Serializer();
    }

    private static class Serializer implements JsonSerializer<ClientDoorSchema>, JsonDeserializer<ClientDoorSchema> {

        @Override
        public ClientDoorSchema deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
                throws JsonParseException {
            class_2960 id;

            try {
                id = new class_2960(json.getAsJsonPrimitive().getAsString());
            } catch (class_151 e) {
                id = CapsuleDoorVariant.REFERENCE;
            }

            return ClientDoorRegistry.getInstance().get(id);
        }

        @Override
        public JsonElement serialize(ClientDoorSchema src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.id().toString());
        }
    }
}
