package dev.amble.ait.data.schema.door;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.lib.client.bedrock.BedrockAnimationReference;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.util.PortalOffsets;

public class DatapackDoor extends DoorSchema implements AnimatedDoor {
    public static final Codec<DatapackDoor> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_2960.field_25139.fieldOf("id").forGetter(DoorSchema::id),
            class_2960.field_25139.fieldOf("open_sound").forGetter(DatapackDoor::getOpenSoundId),
            class_2960.field_25139.fieldOf("close_sound").forGetter(DatapackDoor::getCloseSoundId),
            class_2960.field_25139.fieldOf("model").forGetter(DatapackDoor::getModelId),
            Codec.BOOL.fieldOf("is_double").forGetter(DoorSchema::isDouble),
            PortalOffsets.CODEC.optionalFieldOf("portal_info", new PortalOffsets(1, 2)).forGetter(DatapackDoor::getOffsets),
            BedrockAnimationReference.CODEC.optionalFieldOf("left_animation").forGetter(DatapackDoor::getLeftAnimation),
            BedrockAnimationReference.CODEC.optionalFieldOf("right_animation").forGetter(DatapackDoor::getRightAnimation),
            class_243.field_38277.optionalFieldOf("scale", new class_243(1, 1, 1)).forGetter(DatapackDoor::getScale),
            class_243.field_38277.optionalFieldOf("offset", new class_243(0, 0, 0)).forGetter(DatapackDoor::getOffset),
            Codec.BOOL.optionalFieldOf("isDatapack", true).forGetter(DatapackDoor::wasDatapack)
        ).apply(instance, DatapackDoor::new)
    );

    protected final class_2960 openSound;
    protected final class_2960 closeSound;
    protected final class_2960 model;
    protected final boolean isDouble;
    protected final PortalOffsets offsets;
    protected final BedrockAnimationReference leftAnimation;
    protected final BedrockAnimationReference rightAnimation;
    protected final class_243 scale;
    protected final class_243 offset;
    protected final boolean initiallyDatapack;

    public DatapackDoor(class_2960 id, class_2960 openSound, class_2960 closeSound, class_2960 model, boolean isDouble, PortalOffsets offsets, Optional<BedrockAnimationReference> leftAnimation, Optional<BedrockAnimationReference> rightAnimation, class_243 scale, class_243 offset, boolean initiallyDatapack) {
        super(id);

        this.openSound = openSound;
        this.closeSound = closeSound;
        this.model = model;
        this.isDouble = isDouble;
        this.offsets = offsets;
        this.leftAnimation = leftAnimation.orElse(null);
        this.rightAnimation = rightAnimation.orElse(null);
        this.scale = scale;
        this.offset = offset;
        this.initiallyDatapack = initiallyDatapack;
    }

    @Override
    public boolean isDouble() {
        return isDouble;
    }

    @Override
    public class_3414 openSound() {
        return class_3414.method_47908(getOpenSoundId());
    }

    @Override
    public class_3414 closeSound() {
        return class_3414.method_47908(getCloseSoundId());
    }

    @Override
    public Optional<BedrockAnimationReference> getLeftAnimation() {
        return Optional.ofNullable(leftAnimation);
    }

    @Override
    public Optional<BedrockAnimationReference> getRightAnimation() {
        return Optional.ofNullable(rightAnimation);
    }

    public class_2960 getOpenSoundId() {
        return openSound;
    }

    public class_2960 getCloseSoundId() {
        return closeSound;
    }

    @Override
    public class_243 adjustPortalPos(class_243 pos, class_2350 direction) {
        return this.offsets.apply(direction, pos);
    }

    public PortalOffsets getOffsets() {
        return offsets;
    }

    public boolean wasDatapack() {
        return initiallyDatapack; // Datapack doors are always considered as such
    }

    public class_2960 getModelId() {
        return model;
    }

    @Override
    public class_243 getScale() {
        return scale;
    }

    @Override
    public class_243 getOffset() {
        return offset;
    }

    public static DatapackDoor fromInputStream(InputStream stream) {
        return fromJson(JsonParser.parseReader(new InputStreamReader(stream)).getAsJsonObject());
    }

    public static DatapackDoor fromJson(JsonObject json) {
        AtomicReference<DatapackDoor> created = new AtomicReference<>();

        CODEC.decode(JsonOps.INSTANCE, json).get().ifLeft(recipe -> {
            created.set(recipe.getFirst());
        }).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack door type: {}", err);
        });

        return created.get();
    }

}
