package dev.amble.ait.data.schema.door;

import java.lang.reflect.Type;
import net.minecraft.class_151;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import com.google.gson.*;
import dev.amble.lib.api.Identifiable;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.data.schema.door.impl.CapsuleDoorVariant;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.registry.impl.door.DoorRegistry;
import org.jetbrains.annotations.Nullable;

/**
 * This class provides information about a door for an exterior <br>
 * <br>
 * It's information should be final and set once during creation. <br>
 * <br>
 * It should be registered in {@link DoorRegistry#OLD_REGISTRY} and only obtained
 * from there. <br>
 * <br>
 * This should be referenced by a {@link ExteriorVariantSchema} to be used
 *
 * @author duzo
 * @see DoorRegistry#OLD_REGISTRY
 */
public abstract class DoorSchema implements Identifiable {
    private final class_2960 id;

    protected DoorSchema(class_2960 id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;

        return o instanceof DoorSchema that && id.equals(that.id);
    }

    @Override
    public class_2960 id() {
        return id;
    }

    public abstract boolean isDouble();

    // fixme should this be in a "DoorSounds" type thing, also i dont like these
    // method names.
    public class_3414 openSound() {
        return AITSounds.POLICE_BOX_DOOR_OPEN;
    }

    public class_3414 closeSound() {
        return AITSounds.POLICE_BOX_DOOR_CLOSE;
    }

    /**
     * @deprecated {@link #getPortalPosition()}
     */
    @Deprecated(forRemoval = true)
    public class_243 adjustPortalPos(class_243 pos, class_2350 direction) {
        return pos; // just cus some dont have portals
    }

    @Nullable
    public class_243 getPortalPosition() {
        return adjustPortalPos(class_243.field_1353, class_2350.field_11043);
    }

    @Nullable
    public class_243 getPortalPosition(class_243 origin, float angle) {
        class_243 pos = getPortalPosition();
        if (pos == null) return null;

        return pos.method_1037((float) Math.toRadians(180)).method_1024((float) Math.toRadians(180 - angle)).method_18805(1, -1, 1).method_1019(origin);
    }

    public static Object serializer() {
        return new Serializer();
    }

    private static class Serializer implements JsonSerializer<DoorSchema>, JsonDeserializer<DoorSchema> {

        @Override
        public DoorSchema deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
                throws JsonParseException {
            class_2960 id;

            try {
                id = new class_2960(json.getAsJsonPrimitive().getAsString());
            } catch (class_151 e) {
                id = CapsuleDoorVariant.REFERENCE;
            }

            return DoorRegistry.getInstance().get(id);
        }

        @Override
        public JsonElement serialize(DoorSchema src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.id().toString());
        }
    }
}
