package dev.amble.ait.data.schema.exterior;

import java.lang.reflect.Type;
import java.util.Optional;

import com.google.gson.*;
import dev.amble.lib.register.unlockable.Unlockable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_151;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import dev.amble.ait.AITMod;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.schema.BasicSchema;
import dev.amble.ait.data.schema.door.DoorSchema;
import dev.amble.ait.registry.impl.CategoryRegistry;
import dev.amble.ait.registry.impl.exterior.ClientExteriorVariantRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;
import org.jetbrains.annotations.Nullable;

/**
 * A variant for a {@link ExteriorCategorySchema} which provides a model,
 * texture, emission, and {@link DoorSchema} <br>
 * <br>
 * This should be registered in {@link ExteriorVariantRegistry} <br>
 * <br>
 * This should <b>ONLY</b> be created once in registry, you should grab the
 * class via {@link ExteriorVariantRegistry#get(class_2960)}, the identifier
 * being this variants id variable. <br>
 * <br>
 * It is recommended for implementations of this class to have a static
 * "REFERENCE" {@link class_2960} variable which other things can use to get
 * this from the {@link ExteriorVariantRegistry}
 *
 * @author duzo
 * @see ExteriorVariantRegistry
 */
public abstract class ExteriorVariantSchema extends BasicSchema implements Unlockable {
    private final class_2960 category;
    private final class_2960 id;
    private final Loyalty loyalty;

    public static final double DEFAULT_SEAT_FORWARD_TRANSLATION = 0.5;
    public static final class_243 DEFAULT_SEAT_POS = new class_243(0.5, 1, 0.5);
    @Environment(EnvType.CLIENT)
    private ClientExteriorVariantSchema cachedSchema;

    protected ExteriorVariantSchema(class_2960 category, class_2960 id, Optional<Loyalty> loyalty) {
        super("exterior");
        this.category = category;

        this.id = id;
        this.loyalty = loyalty.orElse(null);
    }

    protected ExteriorVariantSchema(class_2960 category, class_2960 id, Loyalty loyalty) {
        this(category, id, Optional.of(loyalty));
    }
    protected ExteriorVariantSchema(class_2960 category, class_2960 id) {
        this(category, id, Optional.empty());
    }

    public static Object serializer() {
        return new Serializer();
    }

    @Override
    public class_2960 id() {
        return id;
    }

    @Override
    public Optional<Loyalty> requirement() {
        return Optional.ofNullable(loyalty);
    }

    @Override
    public UnlockType unlockType() {
        return UnlockType.EXTERIOR;
    }

    public class_2960 categoryId() {
        return this.category;
    }

    public abstract class_243 seatTranslations();

    public double seatForwardTranslation() {
        return DEFAULT_SEAT_FORWARD_TRANSLATION;
    }

    public ExteriorCategorySchema category() {
        return CategoryRegistry.getInstance().get(this.categoryId());
    }

    @Environment(EnvType.CLIENT)
    public ClientExteriorVariantSchema getClient() {
        if (this.cachedSchema == null)
            this.cachedSchema = ClientExteriorVariantRegistry.withParent(this);

        return cachedSchema;
    }

    public class_265 bounding(class_2350 dir) {
        return null;
    }

    public abstract DoorSchema door();

    public boolean hasPortals() {
        return this.category().hasPortals();
    }

    /**
     * @deprecated {@link #getPortalPosition()}
     */
    @Deprecated(forRemoval = true)
    public class_243 adjustPortalPos(class_243 pos, byte direction) {
        return pos; // just cus some dont have portals
    }

    @Nullable
    public class_243 getPortalPosition() {
        return adjustPortalPos(class_243.field_1353, (byte) 0);
    }

    @Nullable
    public class_243 getPortalPosition(class_243 origin, float angle) {
        class_243 pos = getPortalPosition();
        if (pos == null) return null;

        return pos.method_1037((float) Math.toRadians(180)).method_1024((float) Math.toRadians(180 - angle)).method_18805(1, -1, 1).method_1019(origin);
    }

    public double portalWidth() {
        return 1d;
    }

    public double portalHeight() {
        return 2d;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;

        return o instanceof ExteriorVariantSchema other && id.equals(other.id);
    }

    private static class Serializer
            implements
            JsonSerializer<ExteriorVariantSchema>,
            JsonDeserializer<ExteriorVariantSchema> {

        @Override
        public ExteriorVariantSchema deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
                throws JsonParseException {
            class_2960 id;

            try {
                id = new class_2960(json.getAsJsonPrimitive().getAsString());
            } catch (class_151 e) {
                id = AITMod.id("capsule_default");
            }

            return ExteriorVariantRegistry.getInstance().get(id);
        }

        @Override
        public JsonElement serialize(ExteriorVariantSchema src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.id().toString());
        }
    }
}
