package dev.amble.ait.data.schema.exterior.variant.classic.client;

import org.joml.Vector3f;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.data.datapack.exterior.BiomeOverrides;
import net.minecraft.class_2960;

public class ClientClassicBoxMintVariant extends ClientClassicBoxVariant {
    protected static final class_2960 BIOME_IDENTIFIER = new class_2960(AITMod.MOD_ID, CATEGORY_PATH + "/biome" + "/classic_mint.png");

    private final BiomeOverrides OVERRIDES = BiomeOverrides.builder(ClientClassicBoxVariant.OVERRIDES)
            .with(type -> type.getTexture(BIOME_IDENTIFIER), BiomeHandler.BiomeType.CHORUS, BiomeHandler.BiomeType.SNOWY,
                    BiomeHandler.BiomeType.SCULK)
            .build();

    public ClientClassicBoxMintVariant() {
        super("mint");
    }

    @Override
    public Vector3f sonicItemTranslations() {
        return new Vector3f(0.55f, 1.125f, 1.165f);
    }

    @Override
    public BiomeOverrides overrides() {
        return OVERRIDES;
    }
}
