package dev.amble.ait.data.schema.exterior.variant.dalek_mod;


import dev.amble.ait.AITMod;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.schema.door.DoorSchema;
import dev.amble.ait.data.schema.door.impl.DalekModDoorVariant;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.data.schema.exterior.category.DalekModCategory;
import dev.amble.ait.registry.impl.door.DoorRegistry;
import net.minecraft.class_243;


public abstract class DalekModVariant extends ExteriorVariantSchema {
    protected static final String TEXTURE_PATH = "textures/blockentities/exteriors/dalek_mod/dalek_mod_";

    protected DalekModVariant(int number) {
        super(DalekModCategory.REFERENCE, AITMod.id("exterior/dalek_mod/" + number),
                new Loyalty(Loyalty.Type.OWNER));
    }

    @Override
    public class_243 adjustPortalPos(class_243 pos, byte direction) {
        return switch (direction) {
            case 0 -> pos.method_1031(0, -0.25, -0.59); // NORTH
            case 1, 2, 3 -> pos.method_1031(0.43, -0.25, -0.3); // NORTH EAST p n
            case 4 -> pos.method_1031(0.628, -0.25, 0); // EAST
            case 5, 6, 7 -> pos.method_1031(0.42, -0.25, 0.42); // SOUTH EAST p p
            case 8 -> pos.method_1031(0, -0.25, 0.628); // SOUTH
            case 9, 10, 11 -> pos.method_1031(-0.43, -0.25, 0.45); // SOUTH WEST n p
            case 12 -> pos.method_1031(-0.628, -0.25, 0); // WEST
            case 13, 14, 15 -> pos.method_1031(-0.43, -0.25, -0.45); // NORTH WEST n n
            default -> pos;
        };
    }


    @Override
    public double portalHeight() {
        return 1.9d;
    }

    @Override
    public double portalWidth() {
        return 1d;
    }

    @Override
    public DoorSchema door() {
        return DoorRegistry.getInstance().get(DalekModDoorVariant.REFERENCE);
    }

    @Override
    public class_243 seatTranslations() {
        return new class_243(0.5, 1, 0.5);
    }

    @Override
    public boolean hasPortals() {
        return true;
    }
}
